/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang;

import java.text.DecimalFormat;

public class StringUtils {
    public static String truncate(String toTruncate, int maxSize) {
        return toTruncate.length() > maxSize ? toTruncate.substring(0, maxSize) : toTruncate;
    }

    public static <T> String joinStringsWith(String separator, T ... toBeJoined) {
        String result = "";
        boolean first = true;
        T[] TArray = toBeJoined;
        int n = toBeJoined.length;
        int n2 = 0;
        while (n2 < n) {
            T each = TArray[n2];
            if (!first) {
                result = String.valueOf(result) + separator;
            }
            result = String.valueOf(result) + each;
            first = false;
            ++n2;
        }
        return result;
    }

    public static String joinStringsWith(String separator, double[] toBeJoined, DecimalFormat formatter) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = formatter != null ? formatter.format(toBeJoined[i]) : String.valueOf(toBeJoined[i]);
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static String joinStringsWith(String separator, double[] toBeJoined) {
        return StringUtils.joinStringsWith(separator, toBeJoined, null);
    }

    public static String joinStringsWith(String separator, float[] toBeJoined) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(toBeJoined[i]);
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static String joinStringsWith(String separator, long[] toBeJoined) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(toBeJoined[i]);
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static String joinStringsWith(String separator, int[] toBeJoined) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(toBeJoined[i]);
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static String joinStringsWith(String separator, short[] toBeJoined) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(toBeJoined[i]);
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static String joinStringsWith(String separator, boolean[] toBeJoined) {
        String[] result = new String[toBeJoined.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(Boolean.toString(toBeJoined[i]));
            ++i;
        }
        return StringUtils.joinStringsWith(separator, result);
    }

    public static boolean isNullOrOnlyWhitespace(String title) {
        return title == null || title.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean equalsAny(String subject, String ... toMatch) {
        if (subject == null) {
            return false;
        }
        String[] stringArray = toMatch;
        int n = toMatch.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (subject.equals(each)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String subject, String ... toMatch) {
        if (subject == null) {
            return false;
        }
        String[] stringArray = toMatch;
        int n = toMatch.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (subject.equalsIgnoreCase(each)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean startsWithAnyIgnoreCase(String subject, String ... toMatch) {
        if (subject == null) {
            return false;
        }
        subject = subject.toLowerCase();
        String[] stringArray = toMatch;
        int n = toMatch.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (subject.startsWith(each.toLowerCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String firstCharacterToUpper(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1, s.length());
    }

    public static String safeLimitedSizeString(int maxLength, String stringToLimit) {
        if (stringToLimit == null) {
            return "";
        }
        if (stringToLimit.length() > maxLength) {
            return stringToLimit.substring(0, maxLength - 1);
        }
        return stringToLimit;
    }

    public static String safeLimitedSizeStringWithDots(int maxLength, String stringToLimit) {
        if (stringToLimit == null) {
            return "";
        }
        String result = stringToLimit;
        if (stringToLimit.length() > maxLength) {
            result = String.valueOf(stringToLimit.substring(0, maxLength)) + "...";
            result = StringUtils.keepQuotes(result, stringToLimit);
        }
        return result;
    }

    private static String keepQuotes(String result, String original) {
        String appendChar = "";
        if (original.startsWith("'") && original.endsWith("'")) {
            appendChar = "'";
        } else if (original.startsWith("\"") && original.endsWith("\"")) {
            appendChar = "\"";
        }
        return String.valueOf(result) + appendChar;
    }

    public static String extractString(String fromText, int positionToStart, String beginsWith, String endsWith) {
        int fromPosition = positionToStart - beginsWith.length();
        int toPosition = positionToStart;
        while (fromPosition > 0) {
            if (StringUtils.isMatch(fromText, fromPosition, beginsWith)) break;
            --fromPosition;
        }
        while (toPosition < fromText.length()) {
            if (StringUtils.isMatch(fromText, toPosition, endsWith)) break;
            ++toPosition;
        }
        return fromText.substring(fromPosition == 0 ? 0 : fromPosition + beginsWith.length(), toPosition);
    }

    private static boolean isMatch(String text, int atPosition, String subString) {
        int i = 0;
        while (i < subString.length() && atPosition + i < text.length()) {
            if (subString.charAt(i) != text.charAt(i + atPosition)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] newArrayLength(int length) {
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    public static boolean startsAndEndsWith(String suffixAndPrefix, String message) {
        return message.startsWith(suffixAndPrefix) && message.endsWith(suffixAndPrefix);
    }

    public static String trimStartAndEnd(String prefix, String suffix, String message) {
        if (message.startsWith(prefix)) {
            message = message.substring(prefix.length());
        }
        if (message.endsWith(suffix)) {
            message = message.substring(0, message.length() - suffix.length());
        }
        return message;
    }

    public static String padLeftWith(String padText, String padCharacter, int length) {
        while (padText.length() < length) {
            padText = String.valueOf(padCharacter) + padText;
        }
        return padText;
    }

    public static String padRightWith(String padText, String padCharacter, int length) {
        while (padText.length() < length) {
            padText = String.valueOf(padText) + padCharacter;
        }
        return padText;
    }

    public static String padCenterWith(String padText, String padCharacter, int length) {
        while (padText.length() < length) {
            if ((padText = String.valueOf(padText) + padCharacter).length() >= length) continue;
            padText = String.valueOf(padCharacter) + padText;
        }
        return padText;
    }

    public static int numberOfOccurances(String pattern, String value) {
        int result = 0;
        if (value != null) {
            int i = 0;
            while (i < value.length()) {
                if ((i = value.indexOf(pattern, i)) <= -1) break;
                ++result;
                ++i;
            }
        }
        return result;
    }

    public static String[] divide(String separator, String value) {
        int firstOccuranceOfSeparator = value.indexOf(separator);
        String[] result = new String[]{firstOccuranceOfSeparator == -1 ? value : value.substring(0, firstOccuranceOfSeparator), firstOccuranceOfSeparator == -1 ? "" : value.substring(separator.length() + firstOccuranceOfSeparator)};
        return result;
    }

    public static String[] split(String separator, String value) {
        String[] result = new String[StringUtils.numberOfOccurances(separator, value) + 1];
        int i = 0;
        int start = 0;
        int end = 0;
        while (i < result.length) {
            end = value.indexOf(separator, start);
            if (end == -1) {
                end = value.length();
            }
            result[i] = value.substring(start, end);
            ++i;
            start = end + separator.length();
        }
        return result;
    }

    public static String getTextAfterLastOccurence(String text, char seperator) {
        int n = text.lastIndexOf(seperator) + 1;
        String name = "";
        if (n >= 0 && n < text.length()) {
            name = text.substring(n);
        }
        return name;
    }

    public static String getTextBeforeLastOccurence(String text, char seperator) {
        int n = text.lastIndexOf(seperator);
        String name = "";
        if (n >= 0) {
            name = text.substring(0, n);
        }
        return name;
    }

    public static String ensureEmptyString(String string) {
        return string == null ? "" : string;
    }

    public static boolean containsAnyIgnoreCase(String string, String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            if (StringUtils.containsIgnoreCase(string.toLowerCase(), each.toLowerCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsIgnoreCase(String haystack, String needle) {
        return haystack.toLowerCase().contains(needle.toLowerCase());
    }

    public static boolean containsWord(String string, String word) {
        return string.matches(".*?\\b" + word + "\\b.*?");
    }

    public static String trimCommentAway(String s) {
        String r = "";
        if (s == null) {
            return "";
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '#') break;
            r = String.valueOf(r) + c;
            ++n2;
        }
        return r.trim();
    }

    public static String repeat(String text, int numberOfTimes) {
        String result = "";
        while (numberOfTimes > 0) {
            --numberOfTimes;
            result = String.valueOf(result) + text;
        }
        return result;
    }

    public static boolean isSet(String text) {
        return !StringUtils.isNullOrOnlyWhitespace(text);
    }

    public static String getFirstXConstants(int maxLength, String defaultName) {
        String result = defaultName.replaceAll("[aeiou]|\\W", "");
        if (result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        return result;
    }

    public static String toString(Object subject) {
        return subject == null ? "null" : subject.toString();
    }

    public static int getIndexOfNthOccurance(int n, String pattern, String value) {
        int currentIndex = 0;
        if (value != null) {
            int currentOccurance = 0;
            int index = 0;
            while (currentOccurance < n && index != -1) {
                index = value.indexOf(pattern, currentIndex);
                if (index < 0) continue;
                ++currentOccurance;
                currentIndex = index + 1;
            }
        }
        return currentIndex - 1;
    }

    public static String trim(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString().trim();
    }

    public static String removeMultipleSpacing(String stringToFix) {
        StringBuilder fixedString = new StringBuilder();
        stringToFix = stringToFix.replace("\t", " ");
        String[] strings = stringToFix.split(" ");
        int i = 0;
        while (i < strings.length) {
            String substring = strings[i];
            if (!substring.isEmpty()) {
                fixedString.append(substring);
                if (i != strings.length - 1) {
                    fixedString.append(" ");
                }
            }
            ++i;
        }
        return fixedString.toString();
    }

    public static String trimTrailing(String string) {
        return string.replaceFirst("\\s++$", "");
    }
}

