/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.featuretoggle;

import com.ur.lang.featuretoggle.FeatureToggleSW;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FeatureToggle {
    private static Map<String, Boolean> features = new ConcurrentHashMap<String, Boolean>();

    public static boolean isFeatureDefined(String featureName) {
        return features.containsKey(featureName);
    }

    public static boolean isActive(String featureName) {
        boolean isActive;
        Boolean state = features.get(featureName);
        boolean bl = isActive = state != null && state != false;
        if (!isActive) {
            return FeatureToggleSW.isActive(featureName);
        }
        return isActive;
    }

    public static boolean isInactive(String featureName) {
        return !FeatureToggle.isActive(featureName);
    }

    public static void activateFeature(String featureName) {
        features.put(featureName, true);
    }

    public static void deactivateFeature(String featureName) {
        features.put(featureName, false);
    }

    static void clear() {
        features = new ConcurrentHashMap<String, Boolean>();
    }

    public static void dumpAvailableFeatures(StringWriter writer) {
        boolean appendingNewLine = false;
        for (Map.Entry<String, Boolean> each : features.entrySet()) {
            if (appendingNewLine) {
                writer.append("\n");
            }
            writer.append(String.valueOf(each.getKey()) + "=" + each.getValue());
            appendingNewLine = true;
        }
    }
}

