/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.featuretoggle;

import com.ur.featureflags.featureset.FeatureSet;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FeatureToggleSW {
    private static final Properties featuresetProp = new Properties();
    private static final String PROPERTYFILE = "com/ur/featureflags/featureset/featureset.properties";
    private static final String ENABLE = "ENABLE_";
    private static final String DISABLE = "DISABLE_";

    static {
        FeatureToggleSW.updateFeatureset();
    }

    private FeatureToggleSW() {
    }

    private static void updateFeatureset() {
        InputStream resource = FeatureSet.class.getClassLoader().getResourceAsStream(PROPERTYFILE);
        if (resource != null) {
            try {
                featuresetProp.load(resource);
            }
            catch (IOException e) {
                Log.error("Could not read featureset.properties", e);
            }
        }
    }

    public static boolean isInActive(String featureName) {
        if (FeatureToggleSW.isFeatureDefined(featureName)) {
            return Boolean.parseBoolean(featuresetProp.getProperty(DISABLE + featureName));
        }
        return true;
    }

    public static boolean isActive(String featureName) {
        if (FeatureToggleSW.isFeatureDefined(featureName)) {
            return Boolean.parseBoolean(featuresetProp.getProperty(ENABLE + featureName));
        }
        return false;
    }

    private static boolean isFeatureDefined(String featureName) {
        return featuresetProp.containsKey(DISABLE + featureName);
    }
}

