/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.fuzzy;

public final class FuzzyMatch {
    private final String first;
    private final String second;
    private final int maxStringLength;
    private final int firstLength;
    private final int secondLength;
    private final int[][] distanceMatrix;

    private FuzzyMatch(String first, String second, int maxStringLength) {
        this.first = first;
        this.second = second;
        this.maxStringLength = maxStringLength;
        this.firstLength = Math.min(maxStringLength, first.length());
        this.secondLength = Math.min(maxStringLength, second.length());
        this.distanceMatrix = FuzzyMatch.initializeArray(this.firstLength, this.secondLength);
    }

    private int calculateDistance() {
        int i = 1;
        while (i <= this.firstLength) {
            int j = 1;
            while (j <= this.secondLength) {
                this.distanceMatrix[i][j] = this.getDistanceValue(i, j);
                ++j;
            }
            ++i;
        }
        double multiplier = this.first.length() > this.maxStringLength ? (double)this.maxStringLength / (double)this.first.length() : 1.0;
        return (int)((double)this.distanceMatrix[this.firstLength][this.secondLength] * multiplier);
    }

    private int getDistanceValue(int i, int j) {
        int currentFirstIndex = i - 1;
        int currentSecondIndex = j - 1;
        int previousValue = this.distanceMatrix[currentFirstIndex][currentSecondIndex];
        if (this.first.charAt(currentFirstIndex) == this.second.charAt(currentSecondIndex)) {
            return previousValue;
        }
        return 1 + Math.min(previousValue, Math.min(this.distanceMatrix[currentFirstIndex][j], this.distanceMatrix[i][currentSecondIndex]));
    }

    private static int[][] initializeArray(int firstLength, int secondLength) {
        int[][] result = new int[firstLength + 1][secondLength + 1];
        int i = 0;
        while (i <= firstLength) {
            result[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= secondLength) {
            result[0][j] = j;
            ++j;
        }
        return result;
    }

    public static double matchScore(String first, String second) {
        return FuzzyMatch.matchScore(first, second, Integer.MAX_VALUE);
    }

    public static double matchScore(String first, String second, int maxStringLength) {
        if (first == null || second == null) {
            return first == second ? 1.0f : 0.0f;
        }
        FuzzyMatch matrix = new FuzzyMatch(first, second, maxStringLength);
        int maxLength = Math.max(first.length(), second.length());
        return 1.0 - (double)matrix.calculateDistance() / (double)maxLength;
    }
}

