/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.naming;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import javax.inject.Inject;

public class GenericNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;

    @Inject
    public GenericNamingStrategy(NamingService namingService) {
        super(null);
        this.namingService = namingService;
    }

    @Override
    public void setName(NamedEntity entity, String nameCandidate) {
        nameCandidate = this.convertToValidName(nameCandidate);
        if (EqualsUtil.equals(entity.getName(), nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        if (!this.namingService.isNameUsed(entity.getClass(), nameCandidate)) {
            entity.setName(nameCandidate);
        } else {
            String correctedName = this.namingService.makeUniqueName(entity.getClass(), nameCandidate);
            entity.setName(correctedName);
        }
    }
}

