/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.naming;

import com.ur.lang.naming.GenericNamingStrategy;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NamingStrategyProvider {
    private final Map<Class<?>, NamingStrategy> classToStrategyMap = new ConcurrentHashMap(10);
    private final GenericNamingStrategy genericNamingStrategy;

    @Inject
    public NamingStrategyProvider(GenericNamingStrategy genericNamingStrategy) {
        this.genericNamingStrategy = genericNamingStrategy;
    }

    public void add(NamingStrategy namingStrategy) {
        Class<?> responsibleForType = namingStrategy.getResponsibleForType();
        if (responsibleForType == null) {
            throw new ShouldNotBeContributedToService();
        }
        this.classToStrategyMap.put(responsibleForType, namingStrategy);
    }

    public NamingStrategy getNamingStrategy(Class<? extends NamedEntity> eachEntityClass) {
        if (eachEntityClass == null) {
            return this.genericNamingStrategy;
        }
        NamingStrategy namingStrategy = this.classToStrategyMap.get(eachEntityClass);
        if (namingStrategy != null) {
            return namingStrategy;
        }
        namingStrategy = this.getNamingStrategyAssignableFrom(eachEntityClass);
        return namingStrategy != null ? namingStrategy : this.genericNamingStrategy;
    }

    private NamingStrategy getNamingStrategyAssignableFrom(Class<? extends NamedEntity> eachEntityClass) {
        for (Class<? extends NamedEntity> clazz : this.classToStrategyMap.keySet()) {
            if (!clazz.isAssignableFrom(eachEntityClass)) continue;
            return this.classToStrategyMap.get(clazz);
        }
        return null;
    }

    public class ShouldNotBeContributedToService
    extends RuntimeException {
    }
}

