/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.persist;

import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class WriteableModuleSettings {
    public static final String POLYSCOPE_PATH = ".polyscope";
    private final NiceProperties properties;
    private final File moduleSettings;

    public WriteableModuleSettings(String fileName) {
        this(fileName, new File(System.getProperty("user.home")));
    }

    WriteableModuleSettings(String fileName, File homeFolder) {
        this.moduleSettings = this.moduleSettingsFile(homeFolder, fileName);
        this.properties = this.tryRead(this.moduleSettings);
    }

    public void write() throws IOException {
        FileUtils.writePropertiesToFile(this.moduleSettings.getPath(), this.properties());
    }

    public NiceProperties properties() {
        return this.properties;
    }

    private File moduleSettingsFile(File homeFolder, String fileName) {
        File polyScopePath = new File(homeFolder, POLYSCOPE_PATH);
        if (!polyScopePath.exists()) {
            polyScopePath.mkdir();
        }
        return new File(polyScopePath, fileName);
    }

    private NiceProperties tryRead(File file) {
        if (file.exists()) {
            try {
                return this.read(file);
            }
            catch (IOException ioe) {
                Log.warning("Error reading settings. Returning empty settings: " + file.getPath(), ioe);
                return new NiceProperties(new Properties());
            }
        }
        return new NiceProperties(new Properties());
    }

    private NiceProperties read(File file) throws IOException {
        return new NiceProperties(FileUtils.readPropertiesFromFile(file.getPath()));
    }
}

