/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.react;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import javax.inject.Provider;

public class Broadcaster<T>
extends Recipe<T> {
    public Broadcaster(T initialValue) {
        super(BehaviorSubject.createDefault(initialValue));
    }

    public Broadcaster() {
        super(BehaviorSubject.create());
    }

    protected Subject<T> asSubject() {
        return (Subject)this.observable;
    }

    public void next(T value) {
        this.asSubject().onNext(value);
    }

    public void completed() {
        this.asSubject().onComplete();
    }

    public void error(Throwable e) {
        this.asSubject().onError(e);
    }

    public static <T> Provider<T> latestProvider(Recipe<T> broadcaster) {
        CacheLastItemObserver provider = new CacheLastItemObserver();
        broadcaster.subscribe(provider);
        return provider;
    }

    private static class CacheLastItemObserver<T>
    implements Provider<T>,
    Consumer<T> {
        private T lastValue;

        private CacheLastItemObserver() {
        }

        @Override
        public void accept(T o) {
            this.lastValue = o;
        }

        public T get() {
            return this.lastValue;
        }
    }
}

