/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.react;

import com.ur.lang.react.BiFunction;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Function;
import com.ur.lang.react.Observer;
import com.ur.lang.react.Schedulers;
import com.ur.util.event.Subscription;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public class Recipe<T> {
    private CacheLastItemObserver<T> provider;
    protected final Observable<T> observable;

    Recipe(Observable<T> observable) {
        this.observable = observable;
    }

    protected void finalize() throws Throwable {
        this.provider = null;
        super.finalize();
    }

    public <R> Recipe<R> map(Function<T, R> function) {
        Observable result = this.observable.map(new FunctionWrapper<T, R>(function));
        return new Recipe<T>(result);
    }

    public Recipe<T> distinctUntilChanged() {
        Observable result = this.observable.distinctUntilChanged((BiPredicate)new ArrayAwareComparer());
        return new Recipe<T>(result);
    }

    public Recipe<T> executeOn(Executor executor) {
        Observable result = this.observable.observeOn(io.reactivex.schedulers.Schedulers.from((Executor)executor));
        return new Recipe<T>(result);
    }

    public Recipe<T> executeOnUIThread() {
        return this.executeOn(Schedulers.ui());
    }

    public Recipe<T> executeOnIOThread() {
        return new Recipe<T>(this.observable.subscribeOn(io.reactivex.schedulers.Schedulers.io()));
    }

    public Recipe<T> executeOnComputationThread() {
        return new Recipe<T>(this.observable.subscribeOn(io.reactivex.schedulers.Schedulers.computation()));
    }

    public Recipe<T> filter(com.ur.util.Predicate<T> predicate) {
        Observable result = this.observable.filter(new PredicateWrapper<T>(predicate));
        return new Recipe<T>(result);
    }

    public <U> Recipe<U> scan(U identity, BiFunction<U, T, U> accumulator) {
        Observable result = this.observable.scan(identity, new BiFunctionWrapper<U, T, U>(accumulator));
        return new Recipe<T>(result);
    }

    private void lazyCreateProvider() {
        if (this.provider == null) {
            this.provider = new CacheLastItemObserver();
            this.provider.insertSubscription(this.observable.subscribe(new ConsumerWrapper<T>(this.provider)));
        }
    }

    public Provider<T> lastProvider() {
        this.lazyCreateProvider();
        return this.provider;
    }

    public T last() {
        return (T)this.observable.blockingLast(null);
    }

    public Subscription subscribe(Consumer<T> consumer) {
        Disposable subscription = this.observable.subscribe(new ConsumerWrapper<T>(consumer));
        return new SubscriptionWrapper(subscription);
    }

    public static <T> Recipe<T> combineLatest(Function<Object[], T> function, Recipe ... recipes) {
        ArrayList<Observable<T>> rawRecipes = new ArrayList<Observable<T>>();
        Recipe[] recipeArray = recipes;
        int n = recipes.length;
        int n2 = 0;
        while (n2 < n) {
            Recipe each = recipeArray[n2];
            rawRecipes.add(each.observable);
            ++n2;
        }
        return new Recipe<T>(Observable.combineLatest(rawRecipes, new FunctionWrapper<Object[], T>(function)));
    }

    public static <T, X, Y> Recipe<T> combineLatest(Recipe<X> xRecipe, Recipe<Y> yRecipe, BiFunction<X, Y, T> combineFunction) {
        return new Recipe<T>(Observable.combineLatest(xRecipe.observable, yRecipe.observable, new BiFunctionWrapper<X, Y, T>(combineFunction)));
    }

    public void forEach(Consumer<T> consumer) {
        this.observable.forEach(new ConsumerWrapper<T>(consumer));
    }

    private static class ArrayAwareComparer
    implements BiPredicate<Object, Object> {
        private ArrayAwareComparer() {
        }

        public boolean test(Object left, Object right) {
            boolean result = left == null ? right == null : (left instanceof Object[] && right instanceof Object[] ? Arrays.deepEquals((Object[])left, (Object[])right) : (left instanceof byte[] && right instanceof byte[] ? Arrays.equals((byte[])left, (byte[])right) : (left instanceof short[] && right instanceof short[] ? Arrays.equals((short[])left, (short[])right) : (left instanceof int[] && right instanceof int[] ? Arrays.equals((int[])left, (int[])right) : (left instanceof long[] && right instanceof long[] ? Arrays.equals((long[])left, (long[])right) : (left instanceof char[] && right instanceof char[] ? Arrays.equals((char[])left, (char[])right) : (left instanceof float[] && right instanceof float[] ? Arrays.equals((float[])left, (float[])right) : (left instanceof double[] && right instanceof double[] ? Arrays.equals((double[])left, (double[])right) : (left instanceof boolean[] && right instanceof boolean[] ? Arrays.equals((boolean[])left, (boolean[])right) : left.equals(right))))))))));
            return result;
        }
    }

    private static class BiFunctionWrapper<U, T, R>
    implements io.reactivex.functions.BiFunction<U, T, R> {
        private BiFunction<U, T, R> biFunction;

        public BiFunctionWrapper(BiFunction<U, T, R> biFunction) {
            this.biFunction = biFunction;
        }

        public R apply(U var1, T var2) {
            return this.biFunction.apply(var1, var2);
        }
    }

    private static class CacheLastItemObserver<T>
    implements Provider<T>,
    Consumer<T> {
        private T lastValue;
        private Disposable subscription;

        private CacheLastItemObserver() {
        }

        public void insertSubscription(Disposable subscription) {
            this.subscription = subscription;
        }

        protected void finalize() throws Throwable {
            this.subscription.dispose();
            super.finalize();
        }

        public T get() {
            return this.lastValue;
        }

        @Override
        public void accept(T o) {
            this.lastValue = o;
        }
    }

    private static class ConsumerWrapper<T>
    implements io.reactivex.functions.Consumer<T> {
        private Consumer<T> consumer;

        public ConsumerWrapper(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public void accept(T t) throws Exception {
            this.consumer.accept(t);
        }
    }

    private static class FunctionWrapper<T, R>
    implements io.reactivex.functions.Function<T, R> {
        private Function<T, R> function;

        public FunctionWrapper(Function<T, R> function) {
            this.function = function;
        }

        public R apply(T o) {
            return this.function.call(o);
        }
    }

    private static class ObserverWrapper<T>
    implements io.reactivex.Observer<T> {
        private Observer<T> observer;

        public ObserverWrapper(Observer<T> observer) {
            this.observer = observer;
        }

        public void onComplete() {
            this.observer.onCompleted();
        }

        public void onSubscribe(Disposable d) {
        }

        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        public void onNext(T t) {
            this.observer.onNext(t);
        }
    }

    private static class PredicateWrapper<T>
    implements Predicate<T> {
        private com.ur.util.Predicate<T> predicate;

        public PredicateWrapper(com.ur.util.Predicate<T> predicate) {
            this.predicate = predicate;
        }

        public boolean test(T t) {
            return this.predicate.test(t);
        }
    }

    private class SubscriptionWrapper
    implements Subscription {
        private Disposable subscription;

        public SubscriptionWrapper(Disposable subscription) {
            this.subscription = subscription;
        }

        @Override
        public void dispose() {
            this.subscription.dispose();
        }
    }
}

