/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.react;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;

public class RecipeHelper {
    private Map<Class, Helper> map = new HashMap<Class, Helper>();

    public <X> void add(Class<X> c, Recipe<X> recipe) {
        if (this.map.containsKey(c)) {
            throw new IllegalStateException("Class " + c + " is already added");
        }
        this.map.put(c, new Helper<X>(c, recipe));
    }

    public <X> void add(Class<X> c, Recipe<X> recipe, Consumer<X> consumer) {
        if (this.map.containsKey(c)) {
            throw new IllegalStateException("Class " + c + " is already added");
        }
        this.map.put(c, new Helper<X>(c, recipe, consumer));
    }

    public void remove(Class c) {
        if (this.isSubscribed(c)) {
            Log.warning("Class " + c + " has a subscription. This might need to be disposed");
        }
        this.map.remove(c);
    }

    public <X> Recipe<X> getRecipe(Class<X> c) {
        return this.map.containsKey(c) ? this.map.get(c).recipe : null;
    }

    public <X> X lastProviderValue(Class<X> c) {
        return (X)this.map.get(c).provider.get();
    }

    public void subscribed(Class c, Subscription subscription) {
        if (this.map.containsKey(c)) {
            this.map.get((Object)c).subscription.dispose();
            this.map.get((Object)c).subscription = subscription;
        }
    }

    public boolean isSubscribed(Class c) {
        return this.map.containsKey(c) && this.map.get((Object)c).subscription != Subscription.NULL;
    }

    public void unsubscribe(Class c) {
        if (this.map.containsKey(c)) {
            this.map.get((Object)c).subscription.dispose();
            this.map.get((Object)c).subscription = Subscription.NULL;
        }
    }

    public void subscribe(Class c) {
        Helper h = this.map.get(c);
        if (h.consumer != null) {
            this.unsubscribe(c);
            h.subscription = h.recipe.subscribe(h.consumer);
        }
    }

    public void subscribeOnUIThread(Class c) {
        Helper h = this.map.get(c);
        if (h.consumer != null) {
            this.unsubscribe(c);
            h.subscription = h.recipe.executeOnUIThread().subscribe(h.consumer);
        }
    }

    private static class Helper<X> {
        public final Class<X> c;
        public final Recipe<X> recipe;
        public Consumer<X> consumer;
        public Subscription subscription = Subscription.NULL;
        public Provider<X> provider;

        public Helper(Class<X> c, Recipe<X> recipe) {
            this.c = c;
            this.recipe = recipe;
            this.provider = recipe.lastProvider();
        }

        public Helper(Class<X> c, Recipe<X> recipe, Consumer<X> consumer) {
            this(c, recipe);
            this.consumer = consumer;
        }
    }
}

