/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.react;

import io.reactivex.Scheduler;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;

class Schedulers {
    private static final Executor SWING_EXECUTOR = new SwingExecutor();

    Schedulers() {
    }

    static Executor ui() {
        return SWING_EXECUTOR;
    }

    private static class SchedulerExecutor
    implements Executor {
        private final Scheduler scheduler;

        public SchedulerExecutor(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public void execute(Runnable command) {
            this.scheduler.createWorker().schedule(command);
        }
    }

    static class SwingExecutor
    implements Executor {
        SwingExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            SwingUtilities.invokeLater(command);
        }
    }
}

