/*
 * Decompiled with CFR 0.152.
 */
package com.ur.lang.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8Control
extends ResourceBundle.Control {
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        PropertyResourceBundle bundle = null;
        PushbackInputStream stream = new PushbackInputStream(this.getInputStream(loader, reload, resourceName), 3);
        if (stream != null) {
            try {
                byte[] bom = new byte[3];
                stream.read(bom, 0, 3);
                if (bom[0] != -17 || bom[1] != -69 || bom[2] != -65) {
                    stream.unread(bom[2]);
                    stream.unread(bom[1]);
                    stream.unread(bom[0]);
                }
                bundle = new PropertyResourceBundle(new InputStreamReader((InputStream)stream, "UTF-8"));
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    private InputStream getInputStream(ClassLoader loader, boolean reload, String resourceName) throws IOException {
        InputStream stream = null;
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                stream = connection.getInputStream();
            }
        } else {
            stream = loader.getResourceAsStream(resourceName);
        }
        return stream;
    }
}

