/*
 * Decompiled with CFR 0.152.
 */
package com.ur.math;

import com.ur.math.NumberValue;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Deprecated
public class Angle
implements NumberValue {
    private static final double TWO_PI = Math.PI * 2;
    public static final Angle ZERO = new Angle(0.0);
    public static final Angle HALF_REVOLUTION = new Angle(Math.PI);
    public static final Angle WHOLE_REVOLUTION = new Angle(Math.PI * 2);
    private final double amountInSI;

    private Angle(double amountInSI) {
        this.amountInSI = amountInSI;
    }

    public boolean isLargerThan(Angle other) {
        return this.amountInSI > other.amountInSI;
    }

    public double getIn(Unit unit) {
        return unit.convert(this.amountInSI);
    }

    public Angle plus(Angle other) {
        if (other.amountInSI == 0.0) {
            return this;
        }
        return new Angle(this.amountInSI + other.amountInSI);
    }

    public Angle minus(Angle other) {
        if (other.amountInSI == 0.0) {
            return this;
        }
        return new Angle(this.amountInSI - other.amountInSI);
    }

    public Angle normalized() {
        if (this.amountInSI >= 0.0 && this.amountInSI < Math.PI * 2) {
            return this;
        }
        double angleBetweenMinusTwoPiAndTwoPi = this.amountInSI % (Math.PI * 2);
        double angleBetweenZeroAndTwoPi = angleBetweenMinusTwoPiAndTwoPi >= 0.0 ? angleBetweenMinusTwoPiAndTwoPi : angleBetweenMinusTwoPiAndTwoPi + Math.PI * 2;
        return new Angle(angleBetweenZeroAndTwoPi);
    }

    @Override
    public float asFloat() {
        return (float)this.amountInSI;
    }

    @Override
    public double asDouble() {
        return this.amountInSI;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.amountInSI).toHashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Angle && this.amountInSI == ((Angle)other).amountInSI;
    }

    public String toString() {
        return String.format("%.1f\u00b0", this.getIn(Unit.DEGREES));
    }

    public static Angle from(double amount, Unit unit) {
        return new Angle(unit.unConvert(amount));
    }

    public static enum Unit {
        RADIANS(1.0),
        DEGREES(57.29577951308232);

        public static final Unit SI;
        private final double fromSiToUnit;

        static {
            SI = RADIANS;
        }

        private Unit(double fromSiToUnit) {
            this.fromSiToUnit = fromSiToUnit;
        }

        double convert(double measureInSi) {
            return measureInSi * this.fromSiToUnit;
        }

        double unConvert(double measureInUnit) {
            return measureInUnit / this.fromSiToUnit;
        }
    }
}

