/*
 * Decompiled with CFR 0.152.
 */
package com.ur.math;

import com.ur.lang.Defense;
import com.ur.lang.HashCodeBuilder;

public final class Revolution {
    private static final double EPSILON = 1.0E-5;
    private final int revolutions;
    private final double offset;
    private static final double PI2 = Math.PI * 2;

    public Revolution() {
        this.revolutions = 0;
        this.offset = 0.0;
    }

    public Revolution(Revolution x) {
        this.offset = x.offset;
        this.revolutions = x.revolutions;
    }

    public Revolution(double angle) {
        Defense.isCondition(!Double.isNaN(angle), "Cannot convert NaN");
        Defense.isCondition(!Double.isInfinite(angle), "Angle cannot be infinite");
        Defense.isCondition(Math.abs(angle) / (Math.PI * 2) < 2.147483647E9, "Angle is too large: " + angle);
        int currentRevolutions = (int)(angle / (Math.PI * 2));
        double offsetCount = angle - (double)currentRevolutions * (Math.PI * 2);
        if (offsetCount < 0.0) {
            --currentRevolutions;
            offsetCount += Math.PI * 2;
        }
        this.offset = offsetCount;
        this.revolutions = currentRevolutions;
    }

    public Revolution(int revolutions, double offset) {
        if (offset >= 0.0 && offset < Math.PI * 2) {
            this.revolutions = revolutions;
            this.offset = offset;
        } else {
            Revolution tmp = new Revolution(offset);
            this.revolutions = revolutions + tmp.getRevolutions();
            this.offset = tmp.getOffsetAngle();
        }
    }

    public double getTotalAngle() {
        return (double)this.revolutions * (Math.PI * 2) + this.offset;
    }

    public int getRevolutions() {
        return this.revolutions;
    }

    public double getOffsetAngle() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o instanceof Revolution) {
            Revolution r = (Revolution)o;
            return r.getRevolutions() == this.getRevolutions() && this.epsilonEqual(r.getOffsetAngle(), this.getOffsetAngle());
        }
        return false;
    }

    public boolean epsilonEquals(Revolution other, double epsilon) {
        return other.getRevolutions() == this.getRevolutions() && this.epsilonEqual(other.getOffsetAngle(), this.getOffsetAngle(), epsilon) || other.getRevolutions() == this.getRevolutions() - 1 && this.epsilonEqual(other.getOffsetAngle(), this.getOffsetAngle() + Math.PI * 2, epsilon) || other.getRevolutions() - 1 == this.getRevolutions() && this.epsilonEqual(other.getOffsetAngle() + Math.PI * 2, this.getOffsetAngle(), epsilon);
    }

    private boolean epsilonEqual(double a, double b) {
        return this.epsilonEqual(a, b, 1.0E-5);
    }

    private boolean epsilonEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public int hashCode() {
        return new HashCodeBuilder(4).append(this.revolutions).append(this.offset).toHashCode();
    }

    public String toString() {
        return "(" + this.revolutions + " rev, " + this.offset + " rad)";
    }
}

