/*
 * Decompiled with CFR 0.152.
 */
package com.ur.math;

import com.ur.math.NumberValue;

@Deprecated
public class Speed
implements NumberValue {
    public static final Speed ZERO = new Speed(0.0);
    public static final Speed INFINITE = new Speed(Double.POSITIVE_INFINITY);
    private final double measureInSi;

    private Speed(double measureInSi) {
        this.measureInSi = measureInSi;
    }

    @Override
    public float asFloat() {
        return (float)this.measureInSi;
    }

    @Override
    public double asDouble() {
        return this.measureInSi;
    }

    public double getIn(Unit unit) {
        return unit.convert(this.measureInSi);
    }

    public int hashCode() {
        return (int)(this.measureInSi * 101.0);
    }

    public boolean equals(Object obj) {
        if (obj == null || !Speed.class.equals(obj.getClass())) {
            return false;
        }
        Speed other = (Speed)obj;
        return this.asFloat() == other.asFloat();
    }

    public String toString() {
        return String.valueOf(this.measureInSi) + "m/s";
    }

    public static Speed from(double measure, Unit unit) {
        return new Speed(unit.unConvert(measure));
    }

    public static Speed min(Speed first, Speed second) {
        return first.measureInSi < second.measureInSi ? first : second;
    }

    public static Speed max(Speed first, Speed second) {
        return first.measureInSi > second.measureInSi ? first : second;
    }

    public static enum Unit {
        MM_S(1000.0),
        INCH_S(39.3701),
        SI(1.0);

        private final double fromSiToUnit;

        private Unit(double fromSiToUnit) {
            this.fromSiToUnit = fromSiToUnit;
        }

        double convert(double measureInSi) {
            return measureInSi * this.fromSiToUnit;
        }

        double unConvert(double measureInUnit) {
            return measureInUnit / this.fromSiToUnit;
        }
    }
}

