/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reference;

import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.reference.ReferenceOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ReferenceHandlingStrategyImpl<K, T, R extends Reference<K, T>>
implements ReferenceHandlingStrategy<K, T, R> {
    protected final Map<K, R> references = new AllowNullKeyConcurrentHashMap();
    protected final Map<K, Collection<ReferenceOwner>> ownerMap = new AllowNullKeyConcurrentHashMap<K, Collection<ReferenceOwner>>();

    @Override
    public R getReference(K key) {
        Reference reference = (Reference)this.references.get(key);
        if (reference == null) {
            reference = this.createReference(key);
            this.references.put(key, reference);
        }
        return (R)reference;
    }

    protected abstract R createReference(K var1);

    @Override
    public R getReferenceTo(T target) {
        return this.getReference(this.getKeyFor(target));
    }

    protected abstract K getKeyFor(T var1);

    @Override
    public void setOwnedReferences(ReferenceOwner owner, Iterable<R> ownedReferences) {
        ArrayList newKeys = new ArrayList();
        for (Reference each : ownedReferences) {
            newKeys.add(each.getKey());
        }
        Iterator<K> keyIterator = this.ownerMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object each = keyIterator.next();
            Collection<ReferenceOwner> owners = this.ownerMap.get(each);
            if (!owners.contains(owner) || newKeys.contains(each)) continue;
            owners.remove(owner);
            if (!owners.isEmpty()) continue;
            keyIterator.remove();
            Reference removed = (Reference)this.references.remove(each);
            this.referenceRemoved(removed);
        }
        for (Object each : ownedReferences) {
            Reference original;
            Object eachKey = each.getKey();
            Collection<ReferenceOwner> owners = this.ownerMap.get(eachKey);
            if (owners == null) {
                owners = new ArrayList<ReferenceOwner>();
                this.ownerMap.put(eachKey, owners);
            }
            if (!owners.contains(owner)) {
                owners.add(owner);
            }
            if ((original = (Reference)this.references.get(eachKey)) == each) continue;
            if (original != null) {
                this.fireSubstituteReference(original, each);
            }
            this.references.put(eachKey, each);
            this.referenceAdded(each);
        }
    }

    protected void referenceAdded(R reference) {
    }

    protected void referenceRemoved(R reference) {
    }

    @Override
    public void keyChange(K oldKey, K newKey) {
        Collection<ReferenceOwner> oldOwners;
        this.referenceChange(this.getReference(newKey));
        Reference referenceToMove = (Reference)this.references.get(oldKey);
        if (referenceToMove != null) {
            this.fireSubstituteReference(referenceToMove, this.getReference(newKey));
            this.references.remove(oldKey);
        }
        if ((oldOwners = this.ownerMap.get(oldKey)) != null) {
            Collection<ReferenceOwner> newOwners = this.ownerMap.get(newKey);
            if (newOwners == null) {
                newOwners = new ArrayList<ReferenceOwner>();
                this.ownerMap.put(newKey, newOwners);
            }
            for (ReferenceOwner each : oldOwners) {
                if (newOwners.contains(each)) continue;
                newOwners.add(each);
            }
            this.ownerMap.remove(oldKey);
        }
    }

    @Override
    public void referenceChange(R reference) {
        Collection<ReferenceOwner> owners = this.ownerMap.get(reference.getKey());
        if (owners != null) {
            for (ReferenceOwner each : new ArrayList<ReferenceOwner>(owners)) {
                each.referenceStateChanged((Reference<?, ?>)reference);
            }
        }
    }

    @Override
    public void allReferencesChanged() {
        for (K eachKey : new ArrayList<K>(this.ownerMap.keySet())) {
            this.referenceChange(this.getReference(eachKey));
        }
    }

    protected void fireSubstituteReference(R oldReference, R newReference) {
        Collection<ReferenceOwner> owners = this.ownerMap.get(oldReference.getKey());
        if (owners != null) {
            for (ReferenceOwner each : new ArrayList<ReferenceOwner>(owners)) {
                each.substituteReference((Reference<?, ?>)oldReference, (Reference<?, ?>)newReference);
            }
        }
    }

    @Override
    public void clear() {
        this.references.clear();
        this.ownerMap.clear();
    }

    static class AllowNullKeyConcurrentHashMap<K, R>
    extends ConcurrentHashMap<K, R> {
        AllowNullKeyConcurrentHashMap() {
        }

        @Override
        public R get(Object key) {
            if (key == null) {
                return null;
            }
            return (R)super.get(key);
        }

        @Override
        public R remove(Object key) {
            if (key == null) {
                return null;
            }
            return (R)super.remove(key);
        }
    }
}

