/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reference;

import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.reference.ReferenceOwner;
import com.ur.reference.ReferenceService;
import com.ur.util.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ReferenceServiceImpl
implements ReferenceService {
    private final StrategyMap strategyMap = new StrategyMap();

    @Override
    public <K, T, R extends Reference<K, T>> void registerReferenceStrategy(Class<R> referenceType, ReferenceHandlingStrategy<K, T, R> referenceStrategy) {
        this.strategyMap.put(referenceType, referenceStrategy);
    }

    @Override
    public <K, T, R extends Reference<K, T>> R getReference(Class<R> type, K key) {
        return this.getStrategy(type).getReference(key);
    }

    @Override
    public <K, T, R extends Reference<K, T>> R getReferenceTo(Class<R> type, T target) {
        return this.getStrategy(type).getReferenceTo(target);
    }

    @Override
    public void setOwnedReferences(ReferenceOwner owner, Iterable<Object> ownedEntities) {
        for (Class<? extends Reference<?, ?>> clazz : this.strategyMap.keySet()) {
            this.setOwnedReferences(clazz, owner, ownedEntities);
        }
    }

    protected void allReferencesChanged() {
        for (Class<? extends Reference<?, ?>> clazz : this.strategyMap.keySet()) {
            this.allReferencesChanged(clazz);
        }
    }

    private <K, T, R extends Reference<K, T>> void allReferencesChanged(Class<R> type) {
        this.getStrategy(type).allReferencesChanged();
    }

    private <K, T, R extends Reference<K, T>> void setOwnedReferences(Class<R> type, ReferenceOwner owner, Iterable<Object> owned) {
        this.getStrategy(type).setOwnedReferences(owner, CollectionUtils.filter(owned, type));
    }

    @Override
    public void clear() {
        for (Class<? extends Reference<?, ?>> clazz : this.strategyMap.keySet()) {
            this.strategyMap.get(clazz).clear();
        }
    }

    protected <K, T, R extends Reference<K, T>> ReferenceHandlingStrategy<K, T, R> getStrategy(Class<R> type) {
        return this.strategyMap.get(type);
    }

    protected abstract Collection<Object> getReferences(ReferenceOwner var1);

    private class StrategyMap {
        private final Map<Class<? extends Reference<?, ?>>, Object> map = new HashMap();

        private StrategyMap() {
        }

        public <K, T, R extends Reference<K, T>> void put(Class<R> refType, ReferenceHandlingStrategy<K, T, R> strategy) {
            this.map.put(refType, strategy);
        }

        public <K, T, R extends Reference<K, T>> ReferenceHandlingStrategy<K, T, R> get(Class<R> refType) {
            return (ReferenceHandlingStrategy)this.map.get(refType);
        }

        public Set<Class<? extends Reference<?, ?>>> keySet() {
            return this.map.keySet();
        }
    }
}

