/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reversible;

import com.ur.reversible.Reversible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReversibleSequence<T>
implements Reversible<T>,
Iterable<Reversible<T>> {
    private final List<Reversible<T>> reversibles;
    private boolean lastWasRedo = true;

    public ReversibleSequence() {
        this.reversibles = new ArrayList<Reversible<T>>();
    }

    public ReversibleSequence(Reversible<T> ... reversibles) {
        this.reversibles = new ArrayList<Reversible<T>>(Arrays.asList(reversibles));
    }

    public ReversibleSequence(List<Reversible<T>> reversibles) {
        this.reversibles = new ArrayList<Reversible<T>>(reversibles);
    }

    public void addReversible(Reversible<T> reversible) {
        this.reversibles.add(reversible);
    }

    @Override
    public T getTarget() {
        if (this.reversibles.size() > 0) {
            return this.lastWasRedo ? this.reversibles.get(this.reversibles.size() - 1).getTarget() : this.reversibles.get(0).getTarget();
        }
        return null;
    }

    @Override
    public void undo() {
        ListIterator<Reversible<T>> it = this.reversibles.listIterator(this.reversibles.size());
        while (it.hasPrevious()) {
            it.previous().undo();
        }
        this.lastWasRedo = false;
    }

    @Override
    public Iterator<Reversible<T>> iterator() {
        ArrayList<Reversible<T>> invertedOrder = new ArrayList<Reversible<T>>(this.reversibles);
        Collections.reverse(invertedOrder);
        return invertedOrder.iterator();
    }

    public boolean contains(Class<Reversible> reversibleClass) {
        for (Reversible<T> reversible : this.reversibles) {
            if (!reversibleClass.isAssignableFrom(reversible.getClass())) continue;
            return true;
        }
        return false;
    }

    public List<Reversible<T>> getReversiblesWithClass(Class reversibleClass) {
        ArrayList<Reversible<T>> reversiblesWithClass = new ArrayList<Reversible<T>>();
        for (Reversible<T> reversible : this.reversibles) {
            if (!reversibleClass.isAssignableFrom(reversible.getClass())) continue;
            reversiblesWithClass.add(reversible);
        }
        return reversiblesWithClass;
    }

    public boolean isEmpty() {
        return this.reversibles.isEmpty();
    }

    public int size() {
        return this.reversibles.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        boolean comma = false;
        for (Reversible<T> each : this.reversibles) {
            if (comma) {
                sb.append(", ");
            }
            comma = true;
            sb.append(each.toString());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

