/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reversible;

import com.ur.reversible.Reversible;
import com.ur.util.logging.Log;
import java.lang.reflect.Method;
import java.util.Arrays;

public class SetProperty<T, V>
implements Reversible<T> {
    private final T target;
    protected final Object invocationTarget;
    protected final String propertyName;
    private final Method setter;
    protected final Object indexObject;
    private final V originalValue;
    private final V newValue;

    public SetProperty(Class<T> targetType, Object invocationTarget, String propertyName, Method setter, V originalValue, V newValue) {
        this(targetType, invocationTarget, propertyName, setter, null, originalValue, newValue);
    }

    public SetProperty(Class<T> targetType, Object invocationTarget, String propertyName, Method setter, Object indexObject, V originalValue, V newValue) {
        this.invocationTarget = invocationTarget;
        this.target = this.extractReversibleTarget(targetType, invocationTarget, indexObject);
        this.propertyName = propertyName;
        this.setter = setter;
        this.indexObject = indexObject;
        this.originalValue = originalValue;
        this.newValue = newValue;
    }

    private T extractReversibleTarget(Class<T> targetType, Object invocationTarget, Object indexObject) {
        if (targetType.isInstance(invocationTarget)) {
            return targetType.cast(invocationTarget);
        }
        if (targetType.isInstance(indexObject)) {
            return targetType.cast(indexObject);
        }
        try {
            Method getTargetMethod = invocationTarget.getClass().getMethod("getTarget", new Class[0]);
            Object methodResult = getTargetMethod.invoke(invocationTarget, new Object[0]);
            return targetType.isInstance(methodResult) ? (T)targetType.cast(methodResult) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public void undo() {
        this.setProperty(this.originalValue);
    }

    private void setProperty(V value) {
        try {
            if (this.indexObject == null) {
                this.setter.invoke(this.invocationTarget, value);
            } else {
                this.setter.invoke(this.invocationTarget, this.indexObject, value);
            }
        }
        catch (Exception e) {
            Log.error("Failed to set property " + this.propertyName + " to " + value, e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.propertyName).append(": ");
        this.appendValue(builder, this.originalValue);
        builder.append(" -> ");
        this.appendValue(builder, this.newValue);
        return builder.toString();
    }

    private void appendValue(StringBuilder builder, V value) {
        if (value instanceof boolean[]) {
            builder.append(Arrays.toString((boolean[])value));
        } else if (value instanceof byte[]) {
            builder.append(Arrays.toString((byte[])value));
        } else if (value instanceof char[]) {
            builder.append(Arrays.toString((char[])value));
        } else if (value instanceof short[]) {
            builder.append(Arrays.toString((short[])value));
        } else if (value instanceof int[]) {
            builder.append(Arrays.toString((int[])value));
        } else if (value instanceof long[]) {
            builder.append(Arrays.toString((long[])value));
        } else if (value instanceof float[]) {
            builder.append(Arrays.toString((float[])value));
        } else if (value instanceof double[]) {
            builder.append(Arrays.toString((double[])value));
        } else if (value instanceof Object[]) {
            builder.append(Arrays.toString((Object[])value));
        } else {
            builder.append(value);
        }
    }
}

