/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reversible;

import com.ur.reversible.Reversible;
import com.ur.util.logging.Log;
import java.lang.reflect.Method;
import java.util.Arrays;

public class SubstituteValues<T, V>
implements Reversible<T> {
    private final T target;
    protected final Object invocationTarget;
    private String methodName;
    private final Method substituteMethod;
    private final V originalValue;
    private final V newValue;

    public SubstituteValues(Class<T> targetType, Object invocationTarget, Method substituteMethod, V originalValue, V newValue, String methodName) {
        this.invocationTarget = invocationTarget;
        this.methodName = methodName;
        this.target = this.extractReversibleTarget(targetType, invocationTarget);
        this.substituteMethod = substituteMethod;
        this.originalValue = originalValue;
        this.newValue = newValue;
    }

    private T extractReversibleTarget(Class<T> targetType, Object invocationTarget) {
        if (targetType.isInstance(invocationTarget)) {
            return targetType.cast(invocationTarget);
        }
        try {
            Method getTargetMethod = invocationTarget.getClass().getMethod("getTarget", new Class[0]);
            Object methodResult = getTargetMethod.invoke(invocationTarget, new Object[0]);
            return targetType.isInstance(methodResult) ? (T)targetType.cast(methodResult) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public void undo() {
        this.substitutevalue(this.newValue, this.originalValue);
    }

    private void substitutevalue(V originalValue, V newValue) {
        try {
            this.substituteMethod.invoke(this.invocationTarget, originalValue, newValue);
        }
        catch (Exception e) {
            Log.error("Failed to substitute: " + this.toString(), e);
        }
    }

    public boolean hasMethodName(String name) {
        return this.methodName.equals(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.substituteMethod.getName());
        builder.append("(");
        this.appendValue(builder, this.originalValue).append(", ");
        this.appendValue(builder, this.newValue).append(")");
        return builder.toString();
    }

    private StringBuilder appendValue(StringBuilder builder, V value) {
        if (value instanceof boolean[]) {
            builder.append(Arrays.toString((boolean[])value));
        } else if (value instanceof byte[]) {
            builder.append(Arrays.toString((byte[])value));
        } else if (value instanceof char[]) {
            builder.append(Arrays.toString((char[])value));
        } else if (value instanceof short[]) {
            builder.append(Arrays.toString((short[])value));
        } else if (value instanceof int[]) {
            builder.append(Arrays.toString((int[])value));
        } else if (value instanceof long[]) {
            builder.append(Arrays.toString((long[])value));
        } else if (value instanceof float[]) {
            builder.append(Arrays.toString((float[])value));
        } else if (value instanceof double[]) {
            builder.append(Arrays.toString((double[])value));
        } else if (value instanceof Object[]) {
            builder.append(Arrays.toString((Object[])value));
        } else {
            builder.append(value);
        }
        return builder;
    }
}

