/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reversible;

import com.ur.reversible.Reversible;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class TreeNodeInsertRemove<T extends DefaultMutableTreeNode>
implements Reversible<T> {
    protected final DefaultTreeModel treeModel;
    protected final T parent;
    protected final T child;
    protected final int index;
    protected final boolean insertAction;
    protected boolean lastActionWasInsert;

    public TreeNodeInsertRemove(DefaultTreeModel treeModel, T parent, T node, int index, boolean insertAction) {
        this.treeModel = treeModel;
        this.parent = parent;
        this.child = node;
        this.index = index;
        this.insertAction = insertAction;
        this.lastActionWasInsert = insertAction;
    }

    @Override
    public T getTarget() {
        return this.lastActionWasInsert ? this.child : this.parent;
    }

    @Override
    public void undo() {
        if (this.insertAction) {
            this.remove();
        } else {
            this.insert();
        }
    }

    public T getParent() {
        return this.parent;
    }

    protected void insert() {
        this.treeModel.insertNodeInto((MutableTreeNode)this.child, (MutableTreeNode)this.parent, this.index);
        this.lastActionWasInsert = true;
    }

    protected void remove() {
        this.treeModel.removeNodeFromParent((MutableTreeNode)this.child);
        this.lastActionWasInsert = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parent.getClass().getName()).append(": ");
        sb.append(this.insertAction ? "insert" : "remove").append(" ");
        sb.append(this.child.getClass().getName());
        sb.append(" (").append(this.index).append(")");
        return sb.toString();
    }
}

