/*
 * Decompiled with CFR 0.152.
 */
package com.ur.reversible;

import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.ReversibleSequence;
import com.ur.reversible.UndoRedoListener;
import com.ur.reversible.UndoRedoService;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.event.EventListenerList;

public class UndoRedoServiceImpl<T>
implements UndoRedoService<T> {
    private static final int MAX_UNDOS = 30;
    private final EventListenerList listeners = new EventListenerList();
    private final Stack<Reversible<T>> undoStack = new Stack();
    private final Stack<Reversible<T>> redoStack = new Stack();
    private final List<Reversible<T>> sequence = new ArrayList<Reversible<T>>();
    private boolean sequenceStarted = false;
    private boolean isUndoing = false;
    private boolean isRedoing = false;

    @Override
    public void addListener(UndoRedoListener<T> listener) {
        this.listeners.add(UndoRedoListener.class, listener);
    }

    @Override
    public void removeListener(UndoRedoListener<T> listener) {
        this.listeners.remove(UndoRedoListener.class, listener);
    }

    @Override
    public int getMaximumNumberOfUndoSteps() {
        return 30;
    }

    @Override
    public boolean isSequenceStarted() {
        return this.sequenceStarted;
    }

    @Override
    public void startSequence() {
        this.sequenceStarted = true;
    }

    @Override
    public void endSequence() {
        this.sequenceStarted = false;
        if (!this.sequence.isEmpty()) {
            this.consume(new ReversibleSequence<T>(this.sequence));
        }
        this.sequence.clear();
    }

    @Override
    public void consume(Reversible<T> reversible) {
        ReversibleAction consumeAction = ReversibleAction.Consume;
        if (!this.isUndoing) {
            if (this.sequenceStarted) {
                this.sequence.add(reversible);
            } else {
                if (!this.isRedoing) {
                    this.redoStack.clear();
                }
                this.removeOldestUndosIfStackTooLarge();
                if (Log.canLog(Log.Level.DEBUG)) {
                    Log.debug("New reversible: " + reversible.toString());
                }
                this.undoStack.push(reversible);
                consumeAction = this.isUndoing || this.isRedoing ? ReversibleAction.Consume : ReversibleAction.ConsumeNew;
            }
        } else if (this.sequenceStarted) {
            this.sequence.add(reversible);
        } else {
            this.removeOldestUndosIfStackTooLarge();
            if (Log.canLog(Log.Level.DEBUG)) {
                Log.debug("New Undo reversible: " + reversible.toString());
            }
            this.redoStack.push(reversible);
            consumeAction = this.isUndoing || this.isRedoing ? ReversibleAction.Consume : ReversibleAction.ConsumeNew;
        }
        this.fireUndoRedoEvent(consumeAction, reversible);
    }

    private void removeOldestUndosIfStackTooLarge() {
        while (this.undoStack.size() >= 30) {
            this.undoStack.remove(0);
        }
    }

    private void fireUndoRedoEvent(ReversibleAction action, Reversible<T> reversible) {
        UndoRedoListener[] undoRedoListenerArray = (UndoRedoListener[])this.listeners.getListeners(UndoRedoListener.class);
        int n = undoRedoListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            UndoRedoListener each = undoRedoListenerArray[n2];
            each.perform(action, reversible);
            ++n2;
        }
    }

    @Override
    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    @Override
    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    @Override
    public Reversible<T> undo() {
        if (this.canUndo()) {
            this.isUndoing = true;
            Reversible<T> reversible = this.undoStack.pop();
            if (reversible instanceof ReversibleSequence) {
                this.startSequence();
            }
            this.fireUndoRedoEvent(ReversibleAction.PreUndo, reversible);
            reversible.undo();
            this.fireUndoRedoEvent(ReversibleAction.PostUndo, reversible);
            if (reversible instanceof ReversibleSequence) {
                this.endSequence();
            }
            this.isUndoing = false;
            return reversible;
        }
        return null;
    }

    @Override
    public Reversible<T> redo() {
        if (this.canRedo()) {
            this.isRedoing = true;
            Reversible<T> reversible = this.redoStack.pop();
            if (reversible instanceof ReversibleSequence) {
                this.startSequence();
            }
            this.fireUndoRedoEvent(ReversibleAction.PreRedo, reversible);
            reversible.undo();
            this.fireUndoRedoEvent(ReversibleAction.PostRedo, reversible);
            if (reversible instanceof ReversibleSequence) {
                this.endSequence();
            }
            this.isRedoing = false;
            return reversible;
        }
        return null;
    }

    @Override
    public boolean isUndoingOrRedoing() {
        return this.isUndoing || this.isRedoing;
    }

    @Override
    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public int getUndoStackSize() {
        return this.undoStack.size();
    }
}

