/*
 * Decompiled with CFR 0.152.
 */
package com.ur.security;

import com.ur.lang.Defense;
import com.ur.security.Privilege;
import com.ur.security.PrivilegeLevelChangeListener;
import com.ur.util.event.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PrivilegeImpl<L extends Enum<L>>
implements Privilege<L> {
    private final SortedMap<L, List<Object>> maximumRestrictions;
    private final List<PrivilegeLevelChangeListener<L>> listeners;
    private final Map<Object, Object> properties = new HashMap<Object, Object>();

    public PrivilegeImpl(Class<L> levelType) {
        Defense.notNull(levelType, "Privilege level type cannot be null.");
        Enum[] levels = (Enum[])levelType.getEnumConstants();
        if (levels == null || levels.length == 0) {
            throw new IllegalArgumentException("At least one privilege mode is required.");
        }
        this.maximumRestrictions = new TreeMap<L, List<Object>>();
        ArrayList<Object> sentinelOwnerSet = new ArrayList<Object>();
        sentinelOwnerSet.add(null);
        Enum lastLevel = levels[levels.length - 1];
        this.maximumRestrictions.put(lastLevel, sentinelOwnerSet);
        this.listeners = new ArrayList<PrivilegeLevelChangeListener<L>>();
    }

    @Override
    public synchronized L getLevel() {
        return (L)((Enum)this.maximumRestrictions.firstKey());
    }

    @Override
    public synchronized void addMaximumRestriction(Object restrictionOwner, L maximalLevel) {
        Defense.notNull(restrictionOwner, "Restriction owner cannot be null.");
        Defense.notNull(maximalLevel, "Supplied level cannot be null.");
        L oldLevel = this.getLevel();
        ArrayList<Object> owners = (ArrayList<Object>)this.maximumRestrictions.get(maximalLevel);
        if (owners == null) {
            owners = new ArrayList<Object>();
            this.maximumRestrictions.put(maximalLevel, owners);
        }
        if (!owners.contains(restrictionOwner)) {
            owners.add(restrictionOwner);
        }
        L newLevel = this.getLevel();
        this.notifyLevelChange(oldLevel, newLevel);
    }

    @Override
    public synchronized void removeRestrictions(Object restrictionOwner) {
        Defense.notNull(restrictionOwner, "Restriction owner cannot be null.");
        L oldLevel = this.getLevel();
        Iterator<L> levelIterator = this.maximumRestrictions.keySet().iterator();
        while (levelIterator.hasNext()) {
            Enum each = (Enum)levelIterator.next();
            List owners = (List)this.maximumRestrictions.get(each);
            if (!owners.contains(restrictionOwner)) continue;
            owners.remove(restrictionOwner);
            if (!owners.isEmpty()) continue;
            levelIterator.remove();
        }
        L newLevel = this.getLevel();
        this.notifyLevelChange(oldLevel, newLevel);
    }

    @Override
    public <T> T get(Class<T> key) {
        Collection<T> values = this.getCollection(key);
        if (values.size() > 1) {
            throw new IllegalStateException("Multiple values were stored");
        }
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Override
    public <T> Collection<T> getCollection(Class<T> key) {
        List result = (List)this.properties.get(key);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    protected <T> void set(Class<T> key, T value) {
        this.setCollection(key, Collections.singleton(value));
    }

    protected <T> void setCollection(Class<T> key, Collection<T> value) {
        if (this.properties.get(key) != null) {
            throw new IllegalStateException("Stored value cannot be modified");
        }
        if (value != null) {
            this.properties.put(key, Collections.unmodifiableCollection(new ArrayList<T>(value)));
        }
    }

    @Override
    public Subscription addLevelChangeListener(final PrivilegeLevelChangeListener<L> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return new Subscription(){

            @Override
            public void dispose() {
                PrivilegeImpl.this.listeners.remove(listener);
            }
        };
    }

    private void notifyLevelChange(L oldLevel, L newLevel) {
        if (oldLevel != newLevel) {
            for (PrivilegeLevelChangeListener<L> each : this.listeners) {
                each.levelChanged(oldLevel, newLevel);
            }
        }
    }
}

