/*
 * Decompiled with CFR 0.152.
 */
package com.ur.time;

import com.ur.time.TimerListener;
import java.util.ArrayList;
import java.util.List;

public interface TimerNotifier {
    public boolean isRunning();

    public void start();

    public void cancel();

    public void addTimerListener(TimerListener var1);

    public static final class NeverTimeoutNotifier
    implements TimerNotifier {
        private boolean isRunning;
        private final List<TimerListener> listeners = new ArrayList<TimerListener>();

        @Override
        public void start() {
            this.isRunning = true;
        }

        @Override
        public void cancel() {
            this.isRunning = false;
            for (TimerListener each : this.listeners) {
                each.timeout();
            }
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void addTimerListener(TimerListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }
}

