/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.util.IterableEnumerationWrapper;
import com.ur.util.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    public static <T> Collection<T> combineAll(Collection<T> ... collections) {
        ArrayList<T> result = new ArrayList<T>();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> each = collectionArray[n2];
            result.addAll(each);
            ++n2;
        }
        return result;
    }

    public static <T> List<T> filter(T[] what, Predicate<? super T> how) {
        return CollectionUtils.filter(Arrays.asList(what), how);
    }

    public static <T> List<T> filter(Iterable<T> what, Predicate<? super T> how) {
        return CollectionUtils.filter(what, how, null);
    }

    public static <T> List<T> filter(Iterable<?> what, Class<T> type) {
        return CollectionUtils.filter(what, new Predicate.AllowAll(), type);
    }

    public static <T> List<T> filter(Enumeration<?> what, Class<T> type) {
        return CollectionUtils.filter(new IterableEnumerationWrapper(what), type);
    }

    public static <E, T> List<T> filter(Iterable<E> what, Predicate<? super E> how, Class<T> type) {
        ArrayList<E> result = new ArrayList<E>();
        for (E each : what) {
            if (type != null && !type.isInstance(each) || !how.test(each)) continue;
            result.add(each);
        }
        return result;
    }

    public static <T> List<T> create(Enumeration<?> children) {
        return CollectionUtils.filter(children, Object.class);
    }

    public static <T> Set<T> asSet(T ... instances) {
        return new HashSet<T>(Arrays.asList(instances));
    }
}

