/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.util.Predicate;
import java.util.Iterator;
import java.util.Map;

public class MapUtils {
    public static <S, T, M extends Map<S, T>> M removeMatching(M map, Predicate<Map.Entry<S, T>> filter) {
        Iterator<Map.Entry<S, T>> entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<S, T> each = entryIterator.next();
            if (!filter.test(each)) continue;
            entryIterator.remove();
        }
        return map;
    }

    public static <S, T, M extends Map<S, T>> M filter(M map, Predicate<Map.Entry<S, T>> filter) {
        Map result = null;
        try {
            result = (Map)map.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
        for (Map.Entry<S, T> each : map.entrySet()) {
            if (!filter.test(each)) continue;
            result.put(each.getKey(), each.getValue());
        }
        return (M)result;
    }

    public static class AllowAll<S, T>
    extends MapPredicate<S, T> {
        @Override
        public boolean test(S s, T t) {
            return true;
        }
    }

    public static class AllowNone<S, T>
    extends MapPredicate<S, T> {
        @Override
        public boolean test(S s, T t) {
            return false;
        }
    }

    public static abstract class MapPredicate<S, T>
    implements Predicate<Map.Entry<S, T>> {
        @Override
        public boolean test(Map.Entry<S, T> t) {
            return this.test(t.getKey(), t.getValue());
        }

        public abstract boolean test(S var1, T var2);
    }
}

