/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.lang.IOUtil;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MonitorJavaProgram {
    protected static final int MAXIMUM_NUMBER_OF_FAILS = 3;
    private List<MonitorListener> listeners = new LinkedList<MonitorListener>();

    public MonitorJavaProgram(final String processName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String pidOfProcess = MonitorJavaProgram.getPid(processName);
                int totalFailsInARow = 0;
                while (true) {
                    if (!MonitorJavaProgram.this.listeners.isEmpty()) {
                        try {
                            String cpuAndMemoryUnparsed = MonitorJavaProgram.this.getCpuAndMemory(pidOfProcess);
                            String values = cpuAndMemoryUnparsed.split("\n")[1].trim();
                            String cpuValue = values.split(" ")[0];
                            String memValue = values.substring(values.indexOf(" ")).trim();
                            MonitorJavaProgram.this.updateMonitorListeners(cpuValue, memValue);
                            totalFailsInARow = 0;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            if (totalFailsInARow <= 3) {
                                Log.info("Fetching the cpu info failed, but keeping alive for process " + pidOfProcess + ", trying to fetch pid again.");
                            }
                            MonitorJavaProgram.this.informErrorToListeners("Failed to fetch cpu info");
                            ++totalFailsInARow;
                            pidOfProcess = MonitorJavaProgram.getPid(processName);
                        }
                    }
                    Waiting.pause(2L, TimeUnit.SECONDS);
                }
            }
        }, "Monitor-CPU-and-MEM").start();
    }

    public void addMonitorListener(MonitorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private String getCpuAndMemory(String pidOfProcess) {
        return this.tryToExecuteCommand("ps -p " + pidOfProcess + " -o %cpu,%mem");
    }

    private void updateMonitorListeners(String cpu, String mem) {
        for (MonitorListener each : this.listeners) {
            each.update(cpu, mem);
        }
    }

    private void informErrorToListeners(String message) {
        for (MonitorListener each : this.listeners) {
            each.update(message);
        }
    }

    private static String getPid(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    private String tryToExecuteCommand(String command) {
        String string;
        Process process = null;
        BufferedReader input = null;
        try {
            String result;
            process = Runtime.getRuntime().exec(command);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = result = this.getAllLines(input);
            IOUtil.close(input);
        }
        catch (IOException iOException) {
            return "";
        }
        finally {
            IOUtil.close(input);
            IOUtil.close(process);
        }
        IOUtil.close(process);
        return string;
    }

    private String getAllLines(BufferedReader input) throws IOException {
        String result = "";
        String line = null;
        while ((line = input.readLine()) != null) {
            result = String.valueOf(result) + line + "\n";
        }
        return result;
    }

    public static interface MonitorListener {
        public void update(String var1, String var2);

        public void update(String var1);
    }
}

