/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.lang.ClassUtils;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

public class NiceProperties {
    private Properties originalProperties;
    private Properties properties;

    public NiceProperties(Properties properties) {
        this.properties = properties;
        this.resetOriginalProperties();
    }

    public boolean hasChanges() {
        return !this.originalProperties.equals(this.properties);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.properties.containsKey(key)) {
            String booleanValue = this.properties.getProperty(key);
            return Boolean.parseBoolean(booleanValue);
        }
        return defaultValue;
    }

    public int getInteger(String key, int defaultValue) {
        String intValue = this.properties.getProperty(key);
        try {
            return Integer.parseInt(intValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        String longValue = this.properties.getProperty(key);
        try {
            return Long.parseLong(longValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        String floatValue = this.properties.getProperty(key);
        try {
            return Float.parseFloat(floatValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        String doubleValue = this.properties.getProperty(key);
        try {
            return PrimitiveUtils.parseDouble(doubleValue, defaultValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public <T> Collection<T> getClassInstances(String key, String ... classNames) {
        String names = this.properties.getProperty(key);
        try {
            Collection instancesByName = ClassUtils.getInstancesByName(names.split(" "));
            if (instancesByName.isEmpty()) {
                instancesByName = ClassUtils.getInstancesByName(classNames);
            }
            return instancesByName;
        }
        catch (Exception exception) {
            try {
                return ClassUtils.getInstancesByName(classNames);
            }
            catch (Exception exception2) {
                return Collections.emptyList();
            }
        }
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        String strings = this.properties.getProperty(key);
        try {
            String[] resultAsArray = StringUtils.split(" ", strings);
            return resultAsArray;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue) {
        String enumValue = this.properties.getProperty(key);
        try {
            return Enum.valueOf(defaultValue.getDeclaringClass(), enumValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void store(OutputStream outStream) throws IOException {
        this.properties.store(outStream, "");
        this.resetOriginalProperties();
    }

    public void store(Writer outStream) throws IOException {
        this.properties.store(outStream, "");
        this.resetOriginalProperties();
    }

    private void resetOriginalProperties() {
        this.originalProperties = new Properties();
        try {
            StringWriter writer = new StringWriter();
            this.properties.store(writer, "");
            this.originalProperties.load(new StringReader(writer.toString()));
        }
        catch (IOException iOException) {}
    }
}

