/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

public interface Predicate<T> {
    public boolean test(T var1);

    public static final class AllowAll
    implements Predicate<Object> {
        @Override
        public boolean test(Object t) {
            return true;
        }
    }

    public static final class ByType<E>
    implements Predicate<E> {
        private final Class<? extends E> allowedType;

        public ByType(Class<? extends E> allowedType) {
            this.allowedType = allowedType;
        }

        @Override
        public boolean test(E t) {
            return this.allowedType.isInstance(t);
        }
    }

    public static final class Not<E>
    implements Predicate<E> {
        private final Predicate<E> filter;

        public Not(Predicate<E> filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(E t) {
            return !this.filter.test(t);
        }
    }
}

