/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.lang.ClassUtils;
import com.ur.lang.Defense;
import com.ur.util.logging.Log;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.util.Arrays;

public class Synchronized {
    public static final Class<?>[] THREAD_SAFE_TYPES = new Class[]{Integer.class, Boolean.class, Short.class, Byte.class, Character.class, String.class, Enum.class};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T copyOf(Object sync, T value) {
        if (ClassUtils.isInstanceOfAny(value, THREAD_SAFE_TYPES)) {
            return value;
        }
        Object object = sync;
        synchronized (object) {
            if (ClassUtils.isInstanceOfAny(value, Character.TYPE, Long.class)) {
                T result = value;
                return result;
            }
            if (value instanceof char[]) {
                return (T)Arrays.copyOf((char[])value, Array.getLength(value));
            }
            if (value instanceof int[]) {
                return (T)Arrays.copyOf((int[])value, Array.getLength(value));
            }
            if (value instanceof long[]) {
                return (T)Arrays.copyOf((long[])value, Array.getLength(value));
            }
            if (value instanceof float[]) {
                return (T)Arrays.copyOf((float[])value, Array.getLength(value));
            }
            if (value instanceof double[]) {
                return (T)Arrays.copyOf((double[])value, Array.getLength(value));
            }
            if (value instanceof Object[]) {
                return (T)Arrays.copyOf((Object[])value, Array.getLength(value));
            }
            if (value instanceof Cloneable) {
                try {
                    return (T)value.getClass().getDeclaredMethod("clone", new Class[0]).invoke(value, new Object[0]);
                }
                catch (Exception exception) {
                    Log.warning("Failed to invoke clone() method on " + value.getClass());
                }
            }
            return value;
        }
    }

    public static Thread getThreadByPrefix(String prefix) {
        Thread[] threads;
        Defense.notNull(prefix, "Null prefix");
        Thread[] threadArray = threads = Synchronized.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().startsWith(prefix)) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = Synchronized.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }
}

