/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.lang.Defense;
import com.ur.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TypeFilteringCollection<E, T extends E>
implements Collection<E> {
    private final Collection<T> elements = new ArrayList<T>();
    private final Class<T> type;

    public TypeFilteringCollection(Class<T> type) {
        Defense.notNull(type);
        this.type = type;
    }

    public Collection<T> getFilteredCollection() {
        return new ArrayList<T>(this.elements);
    }

    @Override
    public boolean addAll(Collection<? extends E> newElements) {
        return this.elements.addAll(CollectionUtils.filter(newElements, this.type));
    }

    @Override
    public boolean add(E element) {
        if (this.type.isInstance(element)) {
            return this.elements.add(element);
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            final Iterator<T> iterator;
            {
                this.iterator = TypeFilteringCollection.this.elements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <F> F[] toArray(F[] array) {
        return this.elements.toArray(array);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    public String toString() {
        return this.elements.toString();
    }
}

