/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.util.URPropertyUtils;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.beanutils.PropertyUtils;

@Singleton
public class URPropertyUtilsImpl
implements URPropertyUtils {
    private final Map<String, Method> readMethods = new HashMap<String, Method>();
    private final Map<String, Method> writeMethods = new HashMap<String, Method>();

    @Inject
    public URPropertyUtilsImpl() {
    }

    @Override
    public Object getProperty(Object target, String propertyName) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.getProperty(target, propertyName, null);
    }

    @Override
    public Object getProperty(Object target, String propertyName, Object index) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null.");
        }
        Method getter = this.getReadMethod(target, propertyName, index);
        if (index == null) {
            return getter.invoke(target, new Object[0]);
        }
        return getter.invoke(target, index);
    }

    @Override
    public void setProperty(Object target, String propertyName, Object value) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.setProperty(target, propertyName, null, value);
    }

    @Override
    public void setProperty(Object target, String propertyName, Object index, Object value) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null.");
        }
        Method setter = this.getWriteMethod(target, propertyName, index);
        if (index == null) {
            setter.invoke(target, value);
        } else {
            setter.invoke(target, index, value);
        }
    }

    @Override
    public Method getReadMethod(Object target, String propertyName) throws IllegalArgumentException, NoSuchMethodException {
        return this.getReadMethod(target, propertyName, null);
    }

    @Override
    public Method getReadMethod(Object target, String propertyName, Object index) throws IllegalArgumentException, NoSuchMethodException {
        String propertyKey = this.getLongPropertyName(target, propertyName, index);
        Method result = this.readMethods.get(propertyKey);
        if (result == null) {
            result = this.findReadMethod(target, propertyName, index);
            this.readMethods.put(propertyKey, result);
        }
        return result;
    }

    private Method findReadMethod(Object target, String propertyName, Object index) throws IllegalArgumentException, NoSuchMethodException {
        if (index == null || index instanceof Integer) {
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)target, (String)propertyName);
                boolean isIndexedProperty = descriptor instanceof IndexedPropertyDescriptor;
                boolean expectIndexedProperty = index instanceof Integer;
                if (isIndexedProperty != expectIndexedProperty) {
                    throw new IllegalArgumentException("The property type for property " + this.getLongPropertyName(target, propertyName, index) + " does not match the type detected by PropertyUtils.");
                }
                if (isIndexedProperty) {
                    IndexedPropertyDescriptor indexedDescriptor = (IndexedPropertyDescriptor)descriptor;
                    return indexedDescriptor.getIndexedReadMethod();
                }
                return descriptor.getReadMethod();
            }
            catch (Exception exception) {
                throw new NoSuchMethodException("Failed to find read method for property " + this.getLongPropertyName(target, propertyName, index) + ".");
            }
        }
        String readMethodName = this.getReadMethodName(propertyName);
        Method result = this.getMethod(target.getClass(), readMethodName, index);
        if (result == null) {
            throw new NoSuchMethodException("Failed to find read method for property " + this.getLongPropertyName(target, propertyName, index) + ".");
        }
        return result;
    }

    private Method findRemoveMethod(Object target, String index) throws IllegalArgumentException, NoSuchMethodException {
        Method result = this.getMethod(target.getClass(), "remove", index);
        if (result == null) {
            throw new NoSuchMethodException("Failed to find remove method.");
        }
        return result;
    }

    @Override
    public Method getWriteMethod(Object target, String propertyName) throws IllegalArgumentException, NoSuchMethodException {
        return this.getWriteMethod(target, propertyName, null);
    }

    @Override
    public Method getWriteMethod(Object target, String propertyName, Object index) throws IllegalArgumentException, NoSuchMethodException {
        String propertyKey = this.getLongPropertyName(target, propertyName, index);
        Method result = this.writeMethods.get(propertyKey);
        if (result == null) {
            result = this.findWriteMethod(target, propertyName, index);
            this.writeMethods.put(propertyKey, result);
        }
        return result;
    }

    private Method findWriteMethod(Object target, String propertyName, Object index) throws IllegalArgumentException, NoSuchMethodException {
        Method result;
        if (index == null || index instanceof Integer) {
            try {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)target, (String)propertyName);
                boolean isIndexedProperty = descriptor instanceof IndexedPropertyDescriptor;
                boolean expectIndexedProperty = index instanceof Integer;
                if (isIndexedProperty != expectIndexedProperty) {
                    throw new IllegalArgumentException("The property type for property " + this.getLongPropertyName(target, propertyName, index) + " does not match the type detected by PropertyUtils.");
                }
                if (isIndexedProperty) {
                    IndexedPropertyDescriptor indexedDescriptor = (IndexedPropertyDescriptor)descriptor;
                    result = indexedDescriptor.getIndexedWriteMethod();
                }
                result = descriptor.getWriteMethod();
            }
            catch (Exception exception) {
                throw new NoSuchMethodException("Failed to find write method for property " + this.getLongPropertyName(target, propertyName, index) + ".");
            }
        } else {
            String writeMethodName = this.getWriteMethodName(propertyName);
            result = this.getMethod(target.getClass(), writeMethodName, index, null);
        }
        if (result == null) {
            throw new NoSuchMethodException("Failed to find write method for property " + this.getLongPropertyName(target, propertyName, index) + ".");
        }
        return result;
    }

    @Override
    public String getPropertyName(Method readOrWriteMethod) {
        String methodName = readOrWriteMethod.getName();
        if (!methodName.startsWith("set") && !methodName.startsWith("get") || methodName.length() <= 3) {
            return null;
        }
        char[] fieldNameCharArray = methodName.substring(3).toCharArray();
        fieldNameCharArray[0] = Character.toLowerCase(fieldNameCharArray[0]);
        return new String(fieldNameCharArray);
    }

    @Override
    public String getLongPropertyName(Object target, String propertyName, Object index) {
        StringBuilder sb = new StringBuilder();
        String targetType = target.getClass().getName();
        sb.append(targetType).append(".").append(propertyName);
        if (index != null) {
            String indexType = index.getClass().getName();
            sb.append("[").append(indexType).append("]");
        }
        return sb.toString();
    }

    private String getReadMethodName(String propertyName) {
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private String getWriteMethodName(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    private Method getMethod(Class<?> targetType, String name, Object ... arguments) {
        Method result = null;
        Class<?> currentClass = targetType;
        while (result == null && currentClass != null) {
            Method[] methods;
            Method[] methodArray = methods = currentClass.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method each = methodArray[n2];
                Class<?>[] parameterTypes = each.getParameterTypes();
                if (name.equals(each.getName()) && this.checkParameterTypes(parameterTypes, arguments)) {
                    result = each;
                    break;
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    private boolean checkParameterTypes(Class<?>[] types, Object[] arguments) {
        if (types.length != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            if (arguments[i] != null && !types[i].isInstance(arguments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Method getRemoveMethod(Object target, String index) throws NoSuchMethodException {
        return this.findRemoveMethod(target, index);
    }
}

