/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util;

import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import java.util.concurrent.TimeUnit;

public class Waiting {
    public static boolean pause(long time, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(time));
        }
        catch (InterruptedException e) {
            Log.debug("Failed to pause for: " + time + " " + unit.name() + " do to InterruptedException!\n" + e.toString());
            return false;
        }
        return true;
    }

    public static boolean until(ItHappens itHappens, int timeout, TimeUnit unit) {
        return new Waiter(itHappens).waitFor(unit.toMillis(timeout));
    }

    public static boolean until(ItHappens itHappens, int timeout, int period, TimeUnit unit) {
        return new Waiter(itHappens, unit.toMillis(period)).waitFor(unit.toMillis(timeout));
    }

    public static ItHappens negationOf(ItHappens itHappens) {
        return new NegationOf(itHappens);
    }

    public static <T> ItHappens given(final T subject, final Predicate<T> hasCondition) {
        return new ItHappens(){

            @Override
            public boolean itHappened() {
                return hasCondition.test(subject);
            }
        };
    }

    public static interface ItHappens {
        public boolean itHappened();
    }

    public static final class NegationOf
    implements ItHappens {
        ItHappens eventToNegate;

        public NegationOf(ItHappens eventToNegate) {
            this.eventToNegate = eventToNegate;
        }

        @Override
        public boolean itHappened() {
            return !this.eventToNegate.itHappened();
        }
    }

    private static final class Waiter {
        private final ItHappens ih;
        private final Object lock;
        private boolean finished;
        private long period = 10L;

        public Waiter(ItHappens ih) {
            this.ih = ih;
            this.lock = new Object();
        }

        public Waiter(ItHappens ih, long period) {
            this.ih = ih;
            this.lock = new Object();
            this.period = period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitFor(long timeout) {
            final boolean[] didItHappen = new boolean[1];
            Thread checker = new Thread("Checker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!finished) {
                        Waiting.pause((int)period, TimeUnit.MILLISECONDS);
                        didItHappen[0] = ih.itHappened();
                        if (!didItHappen[0]) continue;
                        finished = true;
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            };
            try {
                Object object = this.lock;
                synchronized (object) {
                    checker.start();
                    this.lock.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                this.finished = true;
                return false;
            }
            this.finished = true;
            return didItHappen[0];
        }
    }
}

