/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.commandline;

import com.ur.lang.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ScriptResource {
    private ArrayList<String> theArgs = new ArrayList();
    private String script;

    public ScriptResource(String name) throws IOException {
        this.loadScript(name);
    }

    public ScriptResource(String name, ArrayList<String> args) throws IOException {
        this.loadScript(name);
        this.theArgs = args;
    }

    private void loadScript(String name) throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/resources/scripts/" + name);
        if (resource == null) {
            throw new IOException("Script \"" + name + "\" is not found.");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(resource));
        try {
            String line = br.readLine();
            this.script = "";
            while (line != null) {
                this.script = String.valueOf(this.script) + line + "\n";
                line = br.readLine();
            }
        }
        finally {
            IOUtil.close(br);
        }
    }

    public String getScript() {
        return this.script;
    }

    public ArrayList<String> getArgs() {
        return this.theArgs;
    }

    public void addArgument(int argument) {
        this.theArgs.add(new Integer(argument).toString());
    }

    public void addArgument(String argument) {
        this.theArgs.add(argument);
    }

    public String toString() {
        return String.valueOf(this.theArgs.toString()) + "\n" + this.script + "\n";
    }
}

