/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.commandline;

import com.ur.util.commandline.ScriptListener;
import com.ur.util.commandline.ScriptResource;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public abstract class ScriptRunner
implements Runnable {
    private String estring = "";
    private boolean hasRun = false;
    private String ostring = "";
    protected int result;
    private String theCommand;
    private PrintStream theErr;
    private String theFileofscript;
    private PrintStream theOut;
    private String theScript;
    private String tstring = "";
    private CopyOnWriteArrayList<ScriptListener> listeners;
    private ArrayList<String> theArgs = new ArrayList();
    private HashMap<String, String> theEnv = new HashMap();

    public ScriptRunner() {
        this.listeners = new CopyOnWriteArrayList();
    }

    protected File buildScript(String script, String filename) throws IOException {
        File fl = new File(filename);
        fl.createNewFile();
        PrintStream ps = new PrintStream(fl);
        ps.println(script);
        ps.close();
        return fl;
    }

    public String getAllString() {
        if (!this.hasRun) {
            throw new RuntimeException("run() has not been called");
        }
        return this.tstring;
    }

    public String getErrorString() {
        if (!this.hasRun) {
            throw new RuntimeException("run() has not been called");
        }
        return this.estring;
    }

    public String getOutputString() {
        if (!this.hasRun) {
            throw new RuntimeException("run() has not been called");
        }
        return this.ostring;
    }

    public int getReturnVal() {
        if (!this.hasRun) {
            throw new RuntimeException("run() has not been called");
        }
        return this.result;
    }

    public void addEnvVar(String var, String value) {
        this.theEnv.put(var, value);
    }

    protected void prepareScriptExecution(String script, String fileofscript, String command, PrintStream out, PrintStream err) {
        this.theScript = script;
        this.theFileofscript = fileofscript;
        this.theCommand = command;
        this.theOut = out;
        this.theErr = err;
        this.hasRun = false;
    }

    protected void prepareScriptExecution(ScriptResource script, String fileofscript, String command, PrintStream out, PrintStream err) {
        this.theScript = script.getScript();
        this.theArgs = script.getArgs();
        this.theFileofscript = fileofscript;
        this.theCommand = command;
        this.theOut = out;
        this.theErr = err;
        this.hasRun = false;
    }

    public synchronized void execute() throws IOException {
        this.execute(0, TimeUnit.SECONDS);
    }

    public synchronized void execute(int timeLimit, TimeUnit unit) throws IOException {
        File scriptfile = null;
        Process ps = null;
        File workingDir = new File("/tmp/");
        try {
            scriptfile = this.buildScript(this.theScript, this.theFileofscript);
            for (String arg : this.theArgs) {
                this.theCommand = String.valueOf(this.theCommand) + " " + arg;
            }
            if (!this.theEnv.isEmpty()) {
                Map<String, String> parentEnv = System.getenv();
                String[] myEnv = new String[parentEnv.size() + this.theEnv.size()];
                int i = 0;
                while (i < myEnv.length) {
                    myEnv[i] = "";
                    ++i;
                }
                Integer myEnvIdx = 0;
                for (String var : parentEnv.keySet()) {
                    if (myEnvIdx < myEnv.length) {
                        myEnv[myEnvIdx.intValue()] = String.valueOf(var) + "=" + parentEnv.get(var);
                        myEnvIdx = myEnvIdx + 1;
                        continue;
                    }
                    Log.debug("WARNING: Index out of bounds copying the parent environment");
                    Log.debug("I will run the process (" + this.theCommand + ") anyway");
                    break;
                }
                for (String var : this.theEnv.keySet()) {
                    if (myEnvIdx < myEnv.length) {
                        myEnv[myEnvIdx.intValue()] = String.valueOf(var) + "=" + this.theEnv.get(var);
                        myEnvIdx = myEnvIdx + 1;
                        continue;
                    }
                    Log.debug("WARNING: Index out of bounds copying extra environment variables");
                    Log.debug("I will run the process (" + this.theCommand + ") anyway");
                    break;
                }
                ps = Runtime.getRuntime().exec(this.theCommand, myEnv, workingDir);
            } else {
                ps = Runtime.getRuntime().exec(this.theCommand, null, workingDir);
            }
            this.result = this.waitFor(ps, this.theOut, this.theErr, timeLimit, unit);
        }
        finally {
            if (ps != null) {
                ps.destroy();
            }
            if (scriptfile != null) {
                scriptfile.delete();
            }
            this.fireOnComplete();
            this.hasRun = true;
        }
    }

    public void executeBackground() {
        Thread t = new Thread((Runnable)this, "ExecuteBashScriptThread");
        t.start();
    }

    protected int waitFor(Process proc, PrintStream opw, PrintStream epw, int timeLimit, TimeUnit unit) {
        long timeout = 0L;
        if (timeLimit > 0) {
            timeout = System.currentTimeMillis() + unit.toMillis(timeLimit);
        }
        while (true) {
            String line;
            BufferedReader ebr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader obr = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            PrintStream input = new PrintStream(proc.getOutputStream());
            while (ebr.ready()) {
                line = ebr.readLine();
                this.estring = String.valueOf(this.estring) + line;
                this.tstring = String.valueOf(this.tstring) + line;
                if (epw != null) {
                    epw.println(line);
                }
                this.fireOnErrLine(line, input);
            }
            while (obr.ready()) {
                line = obr.readLine();
                this.ostring = String.valueOf(this.ostring) + line + "\n";
                this.tstring = String.valueOf(this.tstring) + line + "\n";
                if (opw != null) {
                    opw.println(line);
                }
                this.fireOnStdLine(line, input);
            }
            try {
                int v = proc.exitValue();
                return v;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (timeout > 0L && System.currentTimeMillis() > timeout) {
                    return -101;
                }
                try {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    protected void fireOnStdLine(String line, PrintStream input) {
        for (ScriptListener li : this.listeners) {
            li.onStdLine(line, input);
        }
    }

    protected void fireOnComplete() {
        for (ScriptListener li : this.listeners) {
            li.onComplete(this.result);
        }
    }

    protected void fireOnErrLine(String line, PrintStream input) {
        for (ScriptListener li : this.listeners) {
            li.onErrLine(line, input);
        }
    }

    public void addScriptListener(ScriptListener listener) {
        this.listeners.add(listener);
    }

    public void remScriptListener(ScriptListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Script: " + this.theScript + ", Args: " + this.theArgs + ", Command: " + this.theCommand;
    }
}

