/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.concurrent;

import com.ur.lang.Defense;
import com.ur.util.Waiting;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ConditionalSingleThreadExecutor
implements Executor {
    private static int counter = 0;
    private final FutureStore futures = new FutureStore();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = Executors.defaultThreadFactory().newThread(runnable);
            StringBuilder stringBuilder = new StringBuilder("ConditionalSingleThreadExecutor-");
            int n = counter + 1;
            counter = n;
            result.setName(stringBuilder.append(n).toString());
            result.setDaemon(true);
            return result;
        }
    });
    private final ExecuteWhen executeWhen;

    public ConditionalSingleThreadExecutor() {
        this(new ExecuteWhen(){

            @Override
            public boolean canExecute() {
                return true;
            }
        });
    }

    public ConditionalSingleThreadExecutor(ExecuteWhen conditionWhenRunning) {
        Defense.notNull(conditionWhenRunning, "ExecuteWhen cannot be null");
        this.executeWhen = conditionWhenRunning;
    }

    @Override
    public void execute(Runnable runnable) {
        if (!this.futures.contains(runnable)) {
            Future<?> future = this.executor.submit(new WaitForConditionAndRun(runnable));
            this.futures.register(runnable, future);
        }
    }

    public int itemsEnqueued() {
        return this.futures.futureCount();
    }

    public boolean isEmpty() {
        return this.futures.futureCount() == 0;
    }

    public void clearQueue() {
        this.futures.cancel();
    }

    public static interface ExecuteWhen {
        public boolean canExecute();
    }

    private static class FutureStore {
        private final Map<Runnable, Future<?>> futures = new ConcurrentHashMap();

        private FutureStore() {
        }

        public void register(Runnable runnable, Future<?> future) {
            this.removeDoneFutures();
            this.futures.put(runnable, future);
        }

        public boolean contains(Runnable runnable) {
            this.removeDoneFutures();
            return this.futures.keySet().contains(runnable);
        }

        public int futureCount() {
            this.removeDoneFutures();
            return this.futures.size();
        }

        public void cancel() {
            this.removeDoneFutures();
            for (Future<?> each : this.futures.values()) {
                each.cancel(false);
            }
        }

        private void removeDoneFutures() {
            Iterator<Map.Entry<Runnable, Future<?>>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().isDone()) continue;
                iterator.remove();
            }
        }
    }

    private class WaitForConditionAndRun
    implements Runnable {
        private final Runnable target;

        WaitForConditionAndRun(Runnable target) {
            this.target = target;
        }

        @Override
        public void run() {
            while (!ConditionalSingleThreadExecutor.this.executeWhen.canExecute()) {
                Waiting.pause(250L, TimeUnit.MILLISECONDS);
            }
            this.target.run();
        }
    }
}

