/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.event;

import com.ur.lang.Defense;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.event.Subscription;
import java.lang.reflect.Modifier;

public class EventManagerImpl
implements EventManager {
    @Override
    public <T> Subscription addWeakListener(Object owner, Class<T> type, T listener) {
        Defense.notNull(owner, "Cannot be null owner");
        Defense.notNull(type, "Cannot be null type");
        Defense.notNull(listener, "Cannot be null listener");
        Defense.isCondition(!this.hasStrongLink(owner, listener), "Listener cannot be strongly dependant on owner");
        InternalSubscription result = new InternalSubscription(owner, type, listener);
        result.init();
        return result;
    }

    @Override
    public <T> Subscription addStrongListener(Class<T> type, T listener) {
        Defense.notNull(type, "Cannot be null type");
        Defense.notNull(listener, "Cannot be null listener");
        InternalSubscription result = new InternalSubscription(null, type, listener);
        result.init();
        return result;
    }

    @Override
    public <T> Subscription addVeto(final Class<T> type) {
        EventNotificationService.addVeto(type);
        return new Subscription(){

            @Override
            public void dispose() {
                EventNotificationService.removeVeto(type);
            }
        };
    }

    @Override
    public <T> void fireEvent(Class<T> type, NotificationStrategy<T> notifier) {
        EventNotificationService.notify(type, notifier);
    }

    private boolean hasStrongLink(Object owner, Object listener) {
        boolean result = owner == listener;
        Class<?> listenerClass = listener.getClass();
        Class<?> listenerEnclosingClass = listenerClass.getEnclosingClass();
        Class<?> ownerClass = owner.getClass();
        return result |= listenerEnclosingClass != null && listenerEnclosingClass.equals(ownerClass) && !Modifier.isStatic(listenerClass.getModifiers());
    }

    private static class InternalSubscription<T>
    implements Subscription {
        private final Object owner;
        private final Class<T> type;
        private final T listener;

        private InternalSubscription(Object owner, Class<T> type, T listener) {
            this.owner = owner;
            this.type = type;
            this.listener = listener;
        }

        public void init() {
            EventNotificationService.register(this.owner, this.type, this.listener);
        }

        @Override
        public void dispose() {
            if (this.owner == null) {
                EventNotificationService.unregister(this.listener);
            } else {
                EventNotificationService.unregister(this.owner, this.type);
            }
        }
    }
}

