/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.event;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.util.logging.LogTime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventNotificationService {
    private static final Condition ALWAYS_NOTIFY = new Condition(){

        @Override
        public boolean shouldNotify() {
            return true;
        }

        public String toString() {
            return "ALWAYS NOTIFY";
        }
    };
    private static final Object masterKey = new Object();
    private static final List<Thread.UncaughtExceptionHandler> errorHandlers = Collections.synchronizedList(new ArrayList());
    private static final List<Broadcaster> listeners = new CopyOnWriteArrayList<Broadcaster>();
    private static final List<Class<?>> vetoedTypes = new CopyOnWriteArrayList();

    private EventNotificationService() {
    }

    public static <T> void register(Object owner, Class<T> type, T listener) {
        EventNotificationService.register(owner, type, listener, ALWAYS_NOTIFY);
    }

    public static synchronized <T> void register(Object owner, Class<T> type, T listener, Condition when) {
        Defense.notNull(type, "Type must be specified");
        for (Broadcaster each : listeners) {
            if (!each.contains(owner, type, listener)) continue;
            return;
        }
        Log.trace("Adding listener: " + listener.getClass());
        when = when == null ? ALWAYS_NOTIFY : when;
        Broadcaster weakListener = new Broadcaster(owner, type, listener, when);
        listeners.add(weakListener);
    }

    public static synchronized void unregister(Object listener) {
        for (Broadcaster each : listeners) {
            if (each.getListener() != listener) continue;
            listeners.remove(each);
        }
    }

    public static synchronized void unregister(Object owner, Class<?> type) {
        for (Broadcaster each : listeners) {
            if (!each.hasTypeAndOwner(owner, type)) continue;
            listeners.remove(each);
        }
    }

    public static <T> void notify(Class<T> type, NotificationStrategy<T> notificationHandler) {
        EventNotificationService.notify(type, notificationHandler, true);
    }

    public static <T> void notify(Class<T> type, NotificationStrategy<T> notificationHandler, boolean catchExceptions) {
        for (Broadcaster each : listeners) {
            if (each.owner.get() == null) {
                listeners.remove(each);
                continue;
            }
            each.notify(type, notificationHandler, catchExceptions);
        }
    }

    public static void addErrorHandler(Thread.UncaughtExceptionHandler handler) {
        errorHandlers.add(handler);
    }

    public static void removeErrorHandler(Thread.UncaughtExceptionHandler handler) {
        errorHandlers.remove(handler);
    }

    public static int errorHandlerCount() {
        return errorHandlers.size();
    }

    public static int listenerCount() {
        return listeners.size();
    }

    public static String smartInfo() {
        HashMap<Class, Integer> counts = new HashMap<Class, Integer>();
        for (Broadcaster b : listeners) {
            if (!counts.containsKey(b.type)) {
                counts.put(b.type, 0);
            }
            counts.put(b.type, (Integer)counts.get(b.type) + 1);
        }
        return ((Object)counts).toString();
    }

    public static String dumpListeners() {
        return listeners.toString();
    }

    public static void testingClearAll() {
        listeners.clear();
        errorHandlers.clear();
    }

    public static <T> void addVeto(Class<T> type) {
        if (!vetoedTypes.contains(type)) {
            vetoedTypes.add(type);
        }
    }

    public static <T> void removeVeto(Class<T> type) {
        vetoedTypes.remove(type);
    }

    private static class Broadcaster {
        private final WeakReference<?> owner;
        private final Class<?> type;
        private final Object listener;
        private final Condition when;

        public Broadcaster(Object owner, Class<?> type, Object listener, Condition when) {
            this.owner = new WeakReference<Object>(this.ensureOwner(owner));
            this.type = type;
            this.listener = listener;
            this.when = when;
        }

        private Object ensureOwner(Object owner) {
            return owner == null ? masterKey : owner;
        }

        public <T> boolean contains(Object owner, Class<T> type, T listener) {
            return EqualsUtil.equals(this.owner.get(), this.ensureOwner(owner)) && EqualsUtil.equals(this.type, type) && EqualsUtil.equals(this.listener, listener);
        }

        public <T> void notify(Class<T> type, NotificationStrategy<T> notificationHandler, boolean catchExceptions) {
            if (this.type == type && !vetoedTypes.contains(type) && this.when.shouldNotify()) {
                this.doNotification(notificationHandler, catchExceptions);
            }
        }

        public <T> void notify(Class<T> type, NotificationStrategy<T> notificationHandler) {
            this.notify(type, notificationHandler, true);
        }

        private <T> void doNotification(NotificationStrategy<T> notificationHandler, boolean catchExceptions) {
            String name = "EventNotificationService.notify(" + this.listener.getClass().getName() + ")";
            if (catchExceptions) {
                LogTime.startLog(name);
                try {
                    try {
                        notificationHandler.notify(this.getListener());
                    }
                    catch (Exception e) {
                        this.informOfErrorReceived(e);
                        LogTime.stopLog(name, 25L);
                    }
                }
                finally {
                    LogTime.stopLog(name, 25L);
                }
            } else {
                LogTime.startLog(name);
                notificationHandler.notify(this.getListener());
                LogTime.stopLog(name, 25L);
            }
        }

        private void informOfErrorReceived(Exception e) {
            Thread currentThread = Thread.currentThread();
            new Thread(() -> {
                for (Thread.UncaughtExceptionHandler each : errorHandlers) {
                    each.uncaughtException(currentThread, e);
                }
            }).start();
        }

        public <T> T getListener() {
            return (T)this.listener;
        }

        protected boolean hasTypeAndOwner(Object owner, Class<?> type) {
            return this.owner.get() == owner && this.type.equals(type);
        }

        public String toString() {
            if (this.owner.get() == null) {
                return "***ListenerNode: Should be garbage collected***\n\n";
            }
            return "ListenerNode:\n\tOwner:     " + (this.owner == masterKey ? "No owner" : this.owner.get()) + "\n\tType:      " + this.type + "\n\tListener:  " + this.listener.toString() + "\n\tCondition: " + this.when + "\n\n";
        }
    }

    public static interface Condition {
        public boolean shouldNotify();
    }
}

