/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.event;

import com.ur.lang.EqualsUtil;
import com.ur.util.event.NotificationStrategy;

public class ListenerList<T> {
    private ListenerNode<T> NULL_NODE = new NullNode<T>();
    private ListenerNode<T> listeners = this.NULL_NODE;

    public synchronized void add(T listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners = new ListenerLink<T>(this.listeners, listener);
        }
    }

    public synchronized void remove(T listener) {
        this.listeners = this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners = this.NULL_NODE;
    }

    public void notify(NotificationStrategy<T> handler) {
        this.listeners.handle(handler);
    }

    private static class ListenerLink<S>
    implements ListenerNode<S> {
        private ListenerNode<S> next;
        private final S listener;

        public ListenerLink(ListenerNode<S> next, S listener) {
            this.next = next;
            this.listener = listener;
        }

        @Override
        public boolean contains(S listener) {
            if (EqualsUtil.equals(this.listener, listener)) {
                return true;
            }
            return this.next.contains(listener);
        }

        @Override
        public ListenerNode<S> remove(S listener) {
            if (EqualsUtil.equals(this.listener, listener)) {
                return this.next;
            }
            this.next = this.next.remove(listener);
            return this;
        }

        @Override
        public void handle(NotificationStrategy<S> handler) {
            handler.notify(this.listener);
            this.next.handle(handler);
        }
    }

    private static interface ListenerNode<S> {
        public boolean contains(S var1);

        public ListenerNode<S> remove(S var1);

        public void handle(NotificationStrategy<S> var1);
    }

    private static class NullNode<S>
    implements ListenerNode<S> {
        private NullNode() {
        }

        @Override
        public boolean contains(S listener) {
            return false;
        }

        @Override
        public ListenerNode<S> remove(S listener) {
            return this;
        }

        @Override
        public void handle(NotificationStrategy<S> handler) {
        }
    }
}

