/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import com.ur.lang.IOUtil;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileAppender
extends Log.AbstractLogAppender {
    public static final String LOG_FILE_PATH_KEY = "log.file.appender.path";
    private static final int MAXIMUM_SIZE_IN_MEGABYTES = 5;
    private static final String DEFAULT_LOG_FILE_PATH = System.getenv("HOME");
    private long fileSize;
    private File file;
    private PrintWriter fileWriter;
    private int rollCount;

    public FileAppender() {
        this.rollFileIfTooLarge();
    }

    @Override
    public void writeMessage(String logEntry) {
        if (this.fileWriter != null) {
            this.fileSize += (long)logEntry.getBytes().length;
            this.fileWriter.println(logEntry);
            this.fileWriter.flush();
        }
        this.rollFileIfTooLarge();
    }

    private void rollFileIfTooLarge() {
        try {
            if (this.file == null) {
                this.file = this.getFileWithName("ur-gui.log");
                this.fileSize = this.file.length();
            }
            if (this.fileSize > (long)FileUtils.FileSize.MB.toBits(5)) {
                this.backupFile();
                ++this.rollCount;
            }
            if (this.fileWriter == null) {
                this.fileWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.file, true)));
            }
        }
        catch (IOException ex) {
            System.out.println("Failed to create FileAppender to ur-gui.log\n" + ex);
        }
    }

    private void backupFile() {
        IOUtil.close(this.fileWriter);
        this.fileWriter = null;
        File backupLog = this.getFileWithName("ur-gui.bak");
        if (backupLog.exists()) {
            backupLog.delete();
        }
        this.file.renameTo(backupLog);
        this.file = this.getFileWithName("ur-gui.log");
        this.fileSize = 0L;
    }

    private File getFileWithName(String name) {
        return new File(System.getProperty(LOG_FILE_PATH_KEY, DEFAULT_LOG_FILE_PATH), name);
    }

    public int getRollCount() {
        return this.rollCount;
    }
}

