/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLogger {
    static final long MAX_LINES_IN_LOG = 50000L;
    static final String LOG_FILE_NAME = "/tmp/thelog.log";
    static long currentNoOfEntries = 0L;
    static FileWriter writer = null;
    static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    static String[] oldStrs = null;

    private FileLogger() {
    }

    private static boolean logFileExists() {
        return new File(LOG_FILE_NAME).isFile();
    }

    private static void openLogFile() {
        try {
            if (writer == null) {
                writer = new FileWriter(LOG_FILE_NAME, true);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void checkLogStatus() {
        if (!FileLogger.logFileExists()) {
            currentNoOfEntries = 0L;
        }
        FileLogger.openLogFile();
        if (currentNoOfEntries > 50000L) {
            FileLogger.closeLogFile();
        }
    }

    private static String formatStrings(String ... strs) {
        String s = "";
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            s = s.equals("") ? tmp : String.valueOf(s) + " , " + tmp;
            ++n2;
        }
        if (s.endsWith("\n")) {
            return s;
        }
        return String.valueOf(s) + "\n";
    }

    private static String currentLogEntryNoStr() {
        String tmp = String.valueOf(Long.toString(currentNoOfEntries)) + "               ";
        return tmp.substring(0, 10);
    }

    public static synchronized void Log(Boolean withStackTrace, String ... strs) {
        FileLogger.checkLogStatus();
        if (writer != null) {
            Date date = new Date();
            try {
                writer.write("\n" + FileLogger.currentLogEntryNoStr() + " " + dateFormat.format(date) + "@" + Thread.currentThread().toString() + "> " + FileLogger.formatStrings(strs));
                if (withStackTrace.booleanValue()) {
                    writer.write(FileLogger.getStackTrace());
                }
                ++currentNoOfEntries;
                FileLogger.closeLogFile();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private static String getStackTrace() {
        StackTraceElement[] stackTrace = new Throwable("").getStackTrace();
        String result = "";
        int i = 2;
        while (i < stackTrace.length) {
            result = String.valueOf(result) + "           " + stackTrace[i].toString() + "\n";
            ++i;
        }
        return result;
    }

    public static void UniqueLog(Boolean withStackTrace, String ... strs) {
        if (oldStrs == null) {
            oldStrs = strs;
            FileLogger.Log(withStackTrace, strs);
        } else {
            boolean different = false;
            if (oldStrs.length == strs.length) {
                int i = 0;
                while (i < oldStrs.length) {
                    if (!oldStrs[i].equals(strs[i])) {
                        different = true;
                        break;
                    }
                    ++i;
                }
            } else {
                different = true;
            }
            if (different) {
                oldStrs = strs;
                FileLogger.Log(withStackTrace, strs);
            }
        }
    }

    public static void closeLogFile() {
        if (writer != null) {
            try {
                writer.close();
                writer = null;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        FileLogger.closeLogFile();
    }
}

