/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import com.ur.lang.StringUtils;

class FilterStackTrace {
    FilterStackTrace() {
    }

    private static String formatStackTraceElement(StackTraceElement ste, Integer numberOfOccurrences) {
        String times = numberOfOccurrences > 1 ? StringUtils.padLeftWith(String.valueOf(numberOfOccurrences.toString()) + " x at ", " ", 11) : "\tat ";
        return String.valueOf(times) + ste.toString() + "\n";
    }

    public static String simplifyRepeatingEntries(StackTraceElement[] stackTrace, int maximum_number_of_stacktracelines) {
        String resultingTrace = "";
        StackTraceElement previous = null;
        int previous_repetitions = 0;
        if (stackTrace == null || stackTrace.length == 0) {
            return "";
        }
        previous = stackTrace[0];
        int i = 0;
        while (i < Math.min(stackTrace.length, maximum_number_of_stacktracelines)) {
            StackTraceElement ste = stackTrace[i];
            if (ste.toString().equals(previous.toString())) {
                ++previous_repetitions;
            } else {
                resultingTrace = String.valueOf(resultingTrace) + FilterStackTrace.formatStackTraceElement(previous, previous_repetitions);
                previous = ste;
                previous_repetitions = 0;
            }
            ++i;
        }
        return resultingTrace;
    }
}

