/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import com.ur.util.logging.Log;
import com.ur.util.logging.LogStrategy;
import java.text.SimpleDateFormat;
import java.util.Date;

class InternalLogStrategy
implements LogStrategy {
    InternalLogStrategy() {
    }

    @Override
    public void makeEntry(Log.Level level, StackTraceElement stackTraceElement, String message, Throwable exception) {
        String className = stackTraceElement.getClassName();
        if (Log.canLog(level, className)) {
            String shortNameCallingMethod = this.createCallingMethodFromStackTrace(stackTraceElement, className);
            String threadName = InternalLogStrategy.getThreadName();
            for (Log.LogAppender each : Log.logAppenders) {
                each.writeMessage(level, threadName, InternalLogStrategy.getTime(), shortNameCallingMethod, message, exception);
            }
        }
    }

    private String createCallingMethodFromStackTrace(StackTraceElement stackTraceElement, String className) {
        String callingMethod = String.valueOf(className) + "." + stackTraceElement.getMethodName() + "(line:" + stackTraceElement.getLineNumber() + ")";
        return callingMethod.substring(callingMethod.lastIndexOf(".") + 1);
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    private static String getTime() {
        return new SimpleDateFormat("HH:mm:ss dd/MM/yy").format(new Date());
    }
}

