/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import com.ur.util.logging.ConsoleAppender;
import com.ur.util.logging.FilterStackTrace;
import com.ur.util.logging.InternalLogStrategy;
import com.ur.util.logging.LogStrategy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Log {
    private static final int MAXIMUM_STACK_TRACE_LENGTH = 20;
    private static LogStrategy strategy = new InternalLogStrategy();
    static Level loggingLevel = Level.ERROR;
    static List<LogAppender> logAppenders = new ArrayList<ConsoleAppender>(Collections.singletonList(new ConsoleAppender()));

    public static void setLogStrategy(LogStrategy strategy) {
        Log.strategy = strategy == null ? new InternalLogStrategy() : strategy;
    }

    public static void fatal(String message) {
        Log.makeEntry(message, Level.FATAL, null);
    }

    public static void fatal(String message, Throwable e) {
        Log.makeEntry(message, Level.FATAL, e);
    }

    public static void error(String message) {
        Log.makeEntry(message, Level.ERROR, null);
    }

    public static void error(String message, Throwable e) {
        Log.makeEntry(message, Level.ERROR, e);
    }

    public static void warning(String message) {
        Log.makeEntry(message, Level.WARNING, null);
    }

    public static void warning(String message, Throwable e) {
        Log.makeEntry(message, Level.WARNING, e);
    }

    public static void info(String message) {
        Log.makeEntry(message, Level.INFO, null);
    }

    public static void debug(String message) {
        Log.makeEntry(message, Level.DEBUG, null);
    }

    public static void trace(String message) {
        Log.makeEntry(message, Level.TRACE, null);
    }

    private static void makeEntry(String message, Level level, Throwable exception) {
        if (Log.getLoggingLevel().ordinal() >= level.ordinal()) {
            strategy.makeEntry(level, Log.getCallingMethod(3), message, exception);
        }
    }

    private static StackTraceElement getCallingMethod(int index) {
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        return stackTrace[index];
    }

    public static void attachOutputWriter(LogAppender appender) {
        logAppenders.add(appender);
    }

    public static void detachOutputWriter(LogAppender appender) {
        logAppenders.remove(appender);
    }

    public static void setOutputWriters(Collection<LogAppender> appenders) {
        logAppenders.clear();
        logAppenders.addAll(appenders);
    }

    public static void detachOutputWriters(Collection<LogAppender> appenders) {
        logAppenders.removeAll(appenders);
    }

    public static Level getLoggingLevel() {
        return loggingLevel;
    }

    public static void setLoggingLevel(Level level) {
        loggingLevel = level == null ? Level.INFO : level;
    }

    public static boolean canLog(Level level) {
        return Log.canLog(level, "");
    }

    static boolean canLog(Level level, String callingMethod) {
        return loggingLevel.ordinal() >= level.ordinal();
    }

    public static abstract class AbstractLogAppender
    implements LogAppender {
        @Override
        public void writeMessage(Level level, String threadName, String time, String callingMethod, String message, Throwable exception) {
            String logEntry;
            if (exception == null) {
                logEntry = String.format("%s [%s] %s %s: %s", level.name(), threadName, time, callingMethod, message);
            } else {
                StringWriter captureStackTraceAsString = new StringWriter();
                PrintWriter writer = new PrintWriter(captureStackTraceAsString);
                this.appendStackTrace(exception, writer);
                logEntry = String.format("%s [%s] %s: %s\n%s", level.name(), threadName, time, message, captureStackTraceAsString);
            }
            this.writeMessage(logEntry);
        }

        private void appendStackTrace(Throwable exception, PrintWriter writer) {
            String stackTrace = FilterStackTrace.simplifyRepeatingEntries(exception.getStackTrace(), 20);
            writer.println(exception);
            writer.println(stackTrace);
        }

        protected abstract void writeMessage(String var1);
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }

    public static interface LogAppender {
        public void writeMessage(Level var1, String var2, String var3, String var4, String var5, Throwable var6);
    }
}

