/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.logging;

import com.ur.util.logging.Log;
import java.util.concurrent.ConcurrentHashMap;

public class LogTime {
    private static final ConcurrentHashMap<String, Long> startTimes = new ConcurrentHashMap();

    public static void startLog(String name) {
        if (Log.canLog(Log.Level.DEBUG)) {
            if (startTimes.containsKey(name)) {
                Log.trace("Name [" + name + "] has already been registered.");
            } else {
                startTimes.put(name, System.currentTimeMillis());
            }
        }
    }

    public static void stopLog(String name) {
        LogTime.stopLog(name, "", 0L);
    }

    public static void stopLog(String name, String suffix) {
        LogTime.stopLog(name, suffix, 0L);
    }

    public static void stopLog(String name, long minElapsedTime) {
        LogTime.stopLog(name, "", minElapsedTime);
    }

    public static void stopLog(String name, String suffix, long minElapsedTime) {
        if (Log.canLog(Log.Level.DEBUG)) {
            if (startTimes.containsKey(name)) {
                LogTime.removeEntryAndLog(name, suffix, minElapsedTime);
            } else {
                Log.trace("Name [" + name + "] has not been registered.");
            }
        }
    }

    private static void removeEntryAndLog(String name, String suffix, long minElapsedTime) {
        Long startTime = startTimes.remove(name);
        if (startTime == null) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (elapsedTime > minElapsedTime) {
            Log.debug(String.valueOf(name) + " " + suffix + "\n\tTotal elapsed time: " + elapsedTime + "ms.");
        }
    }
}

