/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.persist;

import com.ur.lang.Defense;
import com.ur.lang.StreamUtils;
import com.ur.util.NiceProperties;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int MAX_NUMBER = 9999;

    public static File getCurrentWorkingDirectory() {
        return new File("").getAbsoluteFile();
    }

    public static boolean bulkMove(FileFilter fileFilter, File fromDirectory, File toDirectory) {
        Defense.isCondition(fromDirectory.exists(), "fromDirectory does not exist");
        Defense.isCondition(fromDirectory.isDirectory(), "fromDirectory is not a directory");
        if (!toDirectory.exists()) {
            toDirectory.mkdirs();
        }
        Defense.isCondition(toDirectory.isDirectory(), "toDirectory is not a directory");
        try {
            File[] fileArray = fromDirectory.listFiles(fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.renameTo(new File(toDirectory, file.getName()));
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.error("No files moved");
            return false;
        }
        return true;
    }

    public static boolean bulkDelete(FileFilter fileFilter, File fromDirectory) {
        Defense.isCondition(fromDirectory.exists(), "fromDirectory does not exist");
        Defense.isCondition(fromDirectory.isDirectory(), "fromDirectory is not a directory");
        try {
            File[] fileArray = Objects.requireNonNull(fromDirectory.listFiles(fileFilter));
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Files.delete(file.toPath());
                ++n2;
            }
        }
        catch (Exception exception) {
            Log.error("No files deleted");
            return false;
        }
        return true;
    }

    public static String getNextAvailableFileName(File directory, String defaultFileName, String extension) {
        int i = 1;
        while (true) {
            String result = String.valueOf(defaultFileName) + "_" + i;
            if (i > 9999) {
                throw new NumberIsTooLarge(9999);
            }
            if (!new File(directory, String.valueOf(result) + extension).exists()) {
                return result;
            }
            ++i;
        }
    }

    public static void copy(String sourceFilename, String destinationFilename) throws IOException {
        FileUtils.copy(new File(sourceFilename), new File(destinationFilename));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File srcFile, File destFile) throws IOException {
        if (!srcFile.exists()) {
            throw new FileNotFoundException(srcFile.getAbsolutePath());
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileChannel source = new FileInputStream(srcFile).getChannel();
            try {
                try (FileChannel destination = new FileOutputStream(destFile).getChannel();){
                    destination.transferFrom(source, 0L, source.size());
                }
                if (source == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (source == null) throw throwable;
                source.close();
                throw throwable;
            }
            source.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void copyDir(File src, File dest) throws IOException {
        if (!dest.isDirectory()) {
            return;
        }
        if (src.isDirectory()) {
            File destDir = new File(String.valueOf(dest.getPath()) + File.separator + src.getName());
            FileUtils.recursiveCopyFiles(src, destDir);
        } else {
            FileUtils.recursiveCopyFiles(src, dest);
        }
    }

    private static void recursiveCopyFiles(File src, File dest) throws IOException {
        if (src.exists()) {
            String script = "cp -r -P \"" + src.getPath() + "\" \"" + dest.getPath() + "\"";
            BashScriptRunner bsr = new BashScriptRunner(script);
            bsr.execute();
        }
    }

    public static void writeToFile(String text, File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.append(text);
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File is not saved: " + file.getName(), e);
        }
    }

    public static String readFromFile(File file, String defaultText) {
        try {
            return StreamUtils.readFromStream(new FileInputStream(file), defaultText);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("File was not found: " + file.getName());
            return defaultText;
        }
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static void unZipIt(File zipFile, File outputFolder) {
        byte[] buffer = new byte[1024];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
                if (!outputFolder.exists()) {
                    outputFolder.mkdir();
                }
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String fileName = ze.getName();
                    File newFile = new File(outputFolder + File.separator + fileName);
                    Log.debug("file unzip : " + newFile.getAbsoluteFile());
                    if (ze.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        new File(newFile.getParent()).mkdirs();
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
                Log.debug("Done");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyDirectory(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] stringArray = src.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileUtils.copyDirectory(srcFile, destFile);
                ++n2;
            }
            return;
        }
        Throwable throwable = null;
        Object var3_7 = null;
        try {
            FileInputStream in = new FileInputStream(src);
            try {
                try (OutputStream out = Files.newOutputStream(dest.toPath(), new OpenOption[0]);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, length);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void appendToFile(File file, String textToAppend) {
        String content = FileUtils.readFromFile(file, "");
        content = String.valueOf(content) + textToAppend;
        FileUtils.writeToFile(content, file);
    }

    public static boolean allowedFileName(String fileName) {
        return !fileName.startsWith(".") && !fileName.contains("&") && !fileName.contains("*") && !fileName.contains("/") && !fileName.contains(";") && !fileName.contains(":") && !fileName.contains("?") && !fileName.contains("\"") && !fileName.contains("<") && !fileName.contains(">") && !fileName.contains("|") && !fileName.contains("\\");
    }

    public static String relativize(File subpath, File path) {
        return subpath.toURI().relativize(path.toURI()).getPath();
    }

    public static String getPath(File file) {
        if (file == null) {
            return "";
        }
        return file.isDirectory() ? file.getPath() : file.getParent();
    }

    public static String getExtension(String fileStr) {
        if (fileStr == null) {
            return null;
        }
        String ext = null;
        int i = fileStr.lastIndexOf(46);
        if (i >= 0 && i < fileStr.length() - 1) {
            ext = fileStr.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(File f) {
        if (f == null) {
            return null;
        }
        return FileUtils.getExtension(f.getName());
    }

    public static String getRandomFilename(String suffix) {
        return String.valueOf(UUID.randomUUID().toString()) + "." + suffix;
    }

    public static boolean delete(File path) {
        boolean result = true;
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                result &= FileUtils.delete(file);
                ++n2;
            }
        }
        return result &= path.delete();
    }

    public static File createTempDir() {
        File tmpDir = new File("/tmp/");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            Log.debug("Unable to create tmp dir " + tmpDir);
            return null;
        }
        File resultDir = null;
        int failureCount = 0;
        while ((resultDir = new File(tmpDir, FileUtils.getRandomFilename("d"))).exists() && ++failureCount < 50) {
        }
        if (resultDir.exists()) {
            Log.error(String.valueOf(failureCount) + " attempts to generate a non-existent directory name failed, giving up");
            return null;
        }
        if (!resultDir.mkdir()) {
            Log.error("Failed to create tmp directory");
            return null;
        }
        return resultDir;
    }

    public static Properties readPropertiesFromFile(String varFile) throws IOException {
        Properties result = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inFile = Files.newInputStream(Paths.get(varFile, new String[0]), new OpenOption[0]);){
            result.load(inFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public static void writePropertiesToFile(String fileNameAndPath, Properties properties) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream outFile = new FileOutputStream(fileNameAndPath);){
            properties.store(outFile, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writePropertiesToFile(String fileNameAndPath, NiceProperties properties) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream outFile = Files.newOutputStream(Paths.get(fileNameAndPath, new String[0]), new OpenOption[0]);){
            properties.store(outFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum FileSize {
        MB(0x100000),
        KB(1024);

        private final int converter;

        private FileSize(int converter) {
            this.converter = converter;
        }

        public int toBits(int amount) {
            return this.converter * amount;
        }
    }

    private static class NumberIsTooLarge
    extends RuntimeException {
        public NumberIsTooLarge(Number maxNumber) {
            super("Number is too large: " + maxNumber);
        }
    }
}

