/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.persist;

import com.ur.util.logging.Log;
import com.ur.util.persist.OptionsSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Options {
    private final Map<String, OptionsSection> keyToSections = new LinkedHashMap<String, OptionsSection>();

    public boolean hasSection(String key) {
        return this.keyToSections.containsKey(key);
    }

    public Iterator<String> getKeys() {
        return this.keyToSections.keySet().iterator();
    }

    public OptionsSection getSection(String key) {
        if (!this.keyToSections.containsKey(key)) {
            this.keyToSections.put(key, new OptionsSection());
        }
        return this.keyToSections.get(key);
    }

    public void setSection(String key, OptionsSection section) {
        this.keyToSections.put(key, section);
    }

    public void save(Writer writer) {
        try {
            try {
                for (String each : this.keyToSections.keySet()) {
                    writer.write("[" + each + "]\n");
                    this.keyToSections.get(each).save(writer);
                    writer.write("\n");
                }
            }
            catch (IOException ex) {
                Log.error("Unable to persist options: ", ex);
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex2) {
                    Log.error("Failed to flush and close options", ex2);
                }
            }
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Log.error("Failed to flush and close options", ex);
            }
        }
    }

    public void load(Reader reader) {
        BufferedReader bufferedReader = (BufferedReader)(reader instanceof BufferedReader ? reader : new BufferedReader(reader));
        try {
            try {
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.isEmpty() || !line.startsWith("[") || !line.endsWith("]")) continue;
                    this.getSection(line.substring(1, line.length() - 1)).load(bufferedReader);
                }
            }
            catch (IOException ex) {
                Log.error("Failed to load options from reader", ex);
                try {
                    bufferedReader.close();
                }
                catch (IOException ex2) {
                    Log.error("Failed to close reader", ex2);
                }
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ex) {
                Log.error("Failed to close reader", ex);
            }
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.save(writer);
        return ((Object)writer).toString();
    }
}

