/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.persist;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.util.logging.Log;
import com.ur.util.persist.Dictionary;
import com.ur.util.persist.PrimitiveDictionary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionsSection
implements Iterable<Map.Entry<String, String>>,
Dictionary,
Cloneable {
    private static final String ASSIGNMENT_SEPARATOR = " = ";
    private static final String SEPARATOR = ", ";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("null|\\[[^\\]]*\\]");
    protected final Map<String, String> keyToValues = new LinkedHashMap<String, String>();

    public OptionsSection() {
    }

    public OptionsSection(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.keyToValues.put(key, map.get(key));
        }
    }

    @Override
    public OptionsSection clone() {
        return new OptionsSection(this.keyToValues);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.keyToValues.put(key, Boolean.toString(value));
    }

    private String getValue(String key) {
        if (this.keyToValues.containsKey(key)) {
            return this.keyToValues.get(key);
        }
        return "";
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            String value = this.getValue(key);
            if (StringUtils.containsAnyIgnoreCase(value, "true", "false")) {
                return Boolean.parseBoolean(value);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setInt(String key, int value) {
        this.keyToValues.put(key, Integer.toString(value));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        try {
            String value = this.getValue(key);
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setDouble(String key, double value) {
        this.keyToValues.put(key, Double.toString(value));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        try {
            String value = this.getValue(key);
            return PrimitiveUtils.parseDouble(value, defaultValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setEnum(String key, Enum<?> enumeration) {
        try {
            this.keyToValues.put(key, enumeration.name());
        }
        catch (Exception exception) {
            this.keyToValues.remove(key);
        }
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        try {
            String value = this.getValue(key);
            return Enum.valueOf(type, value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setLong(String key, long value) {
        this.keyToValues.put(key, Long.toString(value));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        try {
            String value = this.getValue(key);
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setFloat(String key, float value) {
        this.keyToValues.put(key, Float.toString(value));
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        try {
            String value = this.getValue(key);
            return Float.parseFloat(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setString(String key, String value) {
        if (StringUtils.isNullOrOnlyWhitespace(value)) {
            this.keyToValues.remove(key);
        } else {
            this.keyToValues.put(key, value);
        }
    }

    public String getString(String key) {
        return this.getValue(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        if (this.keyToValues.containsKey(key)) {
            return this.getValue(key);
        }
        return defaultValue;
    }

    @Override
    public void setUUID(String key, UUID value) {
        if (value == null) {
            this.keyToValues.remove(key);
        } else {
            this.keyToValues.put(key, value.toString());
        }
    }

    @Override
    public void setArrayOfFloatArrays(String key, float[][] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            ArrayList<String> arrayStrings = new ArrayList<String>();
            float[][] fArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                float[] each = fArray[n2];
                if (each == null) {
                    arrayStrings.add(null);
                } else {
                    arrayStrings.add("[" + StringUtils.joinStringsWith(SEPARATOR, each) + "]");
                }
                ++n2;
            }
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, arrayStrings.toArray()));
        }
    }

    @Override
    public void setArrayOfDoubleArrays(String key, double[][] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            ArrayList<String> arrayStrings = new ArrayList<String>();
            double[][] dArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                double[] each = dArray[n2];
                if (each == null) {
                    arrayStrings.add(null);
                } else {
                    arrayStrings.add("[" + StringUtils.joinStringsWith(SEPARATOR, each) + "]");
                }
                ++n2;
            }
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, arrayStrings.toArray()));
        }
    }

    @Override
    public UUID getUUID(String key, UUID defaultUUID) {
        if (this.keyToValues.containsKey(key)) {
            try {
                return UUID.fromString(this.keyToValues.get(key));
            }
            catch (Exception exception) {
                return defaultUUID;
            }
        }
        return defaultUUID;
    }

    @Override
    public float[][] getArrayOfFloatArrays(String key, float[][] defaultValue) {
        try {
            String value = this.keyToValues.get(key);
            value = StringUtils.trimStartAndEnd("[", "]", value);
            ArrayList<float[]> result = new ArrayList<float[]>();
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(value);
            while (arrayMatcher.find()) {
                String arrayAsString = arrayMatcher.group();
                result.add(PrimitiveUtils.parseFloatArray(this.getArray(arrayAsString)));
            }
            return (float[][])result.toArray((T[])new float[0][]);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public double[][] getArrayOfDoubleArrays(String key, double[][] defaultValue) {
        try {
            String value = this.keyToValues.get(key);
            value = StringUtils.trimStartAndEnd("[", "]", value);
            ArrayList<double[]> result = new ArrayList<double[]>();
            Matcher arrayMatcher = ARRAY_PATTERN.matcher(value);
            while (arrayMatcher.find()) {
                String arrayAsString = arrayMatcher.group();
                result.add(PrimitiveUtils.parseDoubleArray(this.getArray(arrayAsString)));
            }
            return (double[][])result.toArray((T[])new double[0][]);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setStringArray(String key, String[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    @Override
    public String[] getStringArray(String key, String[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return resultAsArray;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void setDoubleArray(String key, double[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    @Override
    public void setIntArray(String key, int[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    @Override
    public void setLongArray(String key, long[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    @Override
    public void setFloatArray(String key, float[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    private void setArray(String key, String arrayValue) {
        this.keyToValues.put(key, "[" + arrayValue + "]");
    }

    @Override
    public void setBooleanArray(String key, boolean[] value) {
        if (value == null || value.length == 0) {
            this.keyToValues.remove(key);
        } else {
            this.setArray(key, StringUtils.joinStringsWith(SEPARATOR, value));
        }
    }

    @Override
    public double[] getDoubleArray(String key, double[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseDoubleArray(resultAsArray);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public int[] getIntArray(String key, int[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseIntegerArray(resultAsArray);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public long[] getLongArray(String key, long[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseLongArray(resultAsArray);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public float[] getFloatArray(String key, float[] defaultValue) {
        try {
            String[] resultAsArray = this.getArrayForKey(key);
            return PrimitiveUtils.parseFloatArray(resultAsArray);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private String[] getArrayForKey(String key) {
        String value = this.keyToValues.get(key);
        return this.getArray(value);
    }

    private String[] getArray(String value) {
        if ((value = StringUtils.trimStartAndEnd("[", "]", value.trim())).isEmpty()) {
            return new String[0];
        }
        String[] result = StringUtils.split(SEPARATOR, value);
        this.preserveNullValues(result);
        return result;
    }

    @Override
    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        if (this.keyToValues.containsKey(key)) {
            try {
                String[] resultAsArray;
                String[] stringArray = resultAsArray = this.getArrayForKey(key);
                int n = resultAsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!StringUtils.containsAnyIgnoreCase(s.trim(), "true", "false")) {
                        return defaultValue;
                    }
                    ++n2;
                }
                return PrimitiveUtils.parseBooleanArray(resultAsArray);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private void preserveNullValues(String[] result) {
        int i = 0;
        while (i < result.length) {
            if (result[i].equals("null")) {
                result[i] = null;
            }
            ++i;
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.keyToValues.entrySet().iterator();
    }

    public Iterator<String> keyIterator() {
        return this.keyToValues.keySet().iterator();
    }

    public void save(Writer writer) {
        try {
            for (String each : this.keyToValues.keySet()) {
                writer.write(String.valueOf(each) + ASSIGNMENT_SEPARATOR + this.keyToValues.get(each) + "\n");
            }
        }
        catch (IOException ex) {
            Log.error("Unable to persist options: ", ex);
        }
    }

    public void load(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().isEmpty()) {
                    return;
                }
                if (line.startsWith("#")) continue;
                String[] split = line.split(ASSIGNMENT_SEPARATOR, 2);
                this.keyToValues.put(split[0], StringUtils.trimCommentAway(split[1]));
            }
        }
        catch (Exception ex) {
            Log.error("Failed to load options from reader", ex);
        }
    }

    @Override
    public Set<String> getKeys() {
        return new LinkedHashSet<String>(this.keyToValues.keySet());
    }

    @Override
    public void loadFromStringRepresentation(String representation) {
        BufferedReader reader = new BufferedReader(new StringReader(representation));
        this.load(reader);
    }

    @Override
    public boolean isSet(String key) {
        return this.keyToValues.containsKey(key);
    }

    @Override
    public boolean remove(String key) {
        if (this.keyToValues.containsKey(key)) {
            this.keyToValues.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean equivalent(PrimitiveDictionary other) {
        boolean same = other instanceof OptionsSection;
        if (same) {
            OptionsSection options = (OptionsSection)other;
            same = this.keyToValues.equals(options.keyToValues);
        }
        return same;
    }
}

