/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.persist;

import com.ur.util.persist.OptionsSection;
import com.ur.util.persist.PrimitiveDictionary;
import com.ur.util.persist.TypedDictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class TypedOptionsSection
extends OptionsSection
implements TypedDictionary {
    private final Map<String, Object> keysToValues = new LinkedHashMap<String, Object>();

    public TypedOptionsSection() {
    }

    public TypedOptionsSection(OptionsSection optionsSection) {
        this.keyToValues.putAll(optionsSection.keyToValues);
    }

    public TypedOptionsSection(Map<String, String> map, Map<String, Object> typedMap) {
        super(map);
        for (String key : typedMap.keySet()) {
            this.keysToValues.put(key, typedMap.get(key));
        }
    }

    public TypedOptionsSection(Map<String, Object> typedMap) {
        this(new HashMap<String, String>(), typedMap);
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.keysToValues.keySet());
        keys.addAll(super.getKeys());
        return keys;
    }

    @Override
    public boolean isSet(String key) {
        return this.keysToValues.containsKey(key) || super.isSet(key);
    }

    @Override
    public boolean remove(String key) {
        return this.keysToValues.remove(key) != null || super.remove(key);
    }

    @Override
    public <T> T get(String key, T defaultValue, Class<T> clazz) {
        Object value = this.keysToValues.get(key);
        if (value != null && clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return defaultValue;
    }

    @Override
    @Deprecated
    public Object getObject(String key) {
        return this.keysToValues.get(key);
    }

    @Override
    public void setObject(String key, Object value) {
        this.remove(key);
        this.keysToValues.put(key, value);
    }

    @Override
    public TypedOptionsSection clone() {
        return new TypedOptionsSection(this.keyToValues, this.keysToValues);
    }

    public Iterator<Map.Entry<String, String>> getPrimitivesIterator() {
        return super.iterator();
    }

    public Iterator<Map.Entry<String, Object>> getTypedIterator() {
        return this.keysToValues.entrySet().iterator();
    }

    @Override
    public boolean equivalent(PrimitiveDictionary other) {
        if (other instanceof TypedOptionsSection) {
            TypedOptionsSection options = (TypedOptionsSection)other;
            return this.keysToValues.equals(options.keysToValues) && super.equivalent(other);
        }
        return false;
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.remove(key);
        super.setBoolean(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.remove(key);
        super.setInt(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.remove(key);
        super.setDouble(key, value);
    }

    @Override
    public void setEnum(String key, Enum<?> enumeration) {
        this.remove(key);
        super.setEnum(key, enumeration);
    }

    @Override
    public void setLong(String key, long value) {
        this.remove(key);
        super.setLong(key, value);
    }

    @Override
    public void setFloat(String key, float value) {
        this.remove(key);
        super.setFloat(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.remove(key);
        super.setString(key, value);
    }

    @Override
    public void setUUID(String key, UUID value) {
        this.remove(key);
        super.setUUID(key, value);
    }

    @Override
    public void setArrayOfFloatArrays(String key, float[][] value) {
        this.remove(key);
        super.setArrayOfFloatArrays(key, value);
    }

    @Override
    public void setArrayOfDoubleArrays(String key, double[][] value) {
        this.remove(key);
        super.setArrayOfDoubleArrays(key, value);
    }

    @Override
    public void setStringArray(String key, String[] value) {
        this.remove(key);
        super.setStringArray(key, value);
    }

    @Override
    public void setDoubleArray(String key, double[] value) {
        this.remove(key);
        super.setDoubleArray(key, value);
    }

    @Override
    public void setIntArray(String key, int[] value) {
        this.remove(key);
        super.setIntArray(key, value);
    }

    @Override
    public void setLongArray(String key, long[] value) {
        this.remove(key);
        super.setLongArray(key, value);
    }

    @Override
    public void setFloatArray(String key, float[] value) {
        this.remove(key);
        super.setFloatArray(key, value);
    }

    @Override
    public void setBooleanArray(String key, boolean[] value) {
        this.remove(key);
        super.setBooleanArray(key, value);
    }

    @Override
    public void setCallback(TypedDictionary.Callback callback) {
    }
}

