/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.swing;

import com.ur.util.swing.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    private static final Icon NULL_ICON = new EmptyIcon(0, 0);
    private final Icon baseIcon;
    private final Icon superScriptIcon;
    private final Icon subScriptIcon;

    public CompoundIcon(Icon baseIcon) {
        this(baseIcon, NULL_ICON, NULL_ICON);
    }

    public CompoundIcon(Icon baseIcon, Icon superScriptIcon, Icon subScriptIcon) {
        this.baseIcon = this.handleNullIcon(baseIcon);
        this.superScriptIcon = this.handleNullIcon(superScriptIcon);
        this.subScriptIcon = this.handleNullIcon(subScriptIcon);
    }

    @Deprecated
    public CompoundIcon(int gap, Icon baseIcon, Icon superScriptIcon, Icon subScriptIcon) {
        this.baseIcon = this.handleNullIcon(baseIcon);
        this.superScriptIcon = this.handleNullIcon(superScriptIcon);
        this.subScriptIcon = this.handleNullIcon(subScriptIcon);
    }

    private Icon handleNullIcon(Icon icon) {
        return icon == null ? NULL_ICON : icon;
    }

    public Icon getBaseIcon() {
        return this.baseIcon;
    }

    public Icon getSubScriptIcon() {
        return this.subScriptIcon;
    }

    public Icon getSuperScriptIcon() {
        return this.superScriptIcon;
    }

    @Deprecated
    public int getGap() {
        return 0;
    }

    @Override
    public int getIconWidth() {
        return this.baseIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.baseIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.baseIcon.paintIcon(c, g, x, y);
        int startSubIconsX = x + this.baseIcon.getIconWidth();
        this.superScriptIcon.paintIcon(c, g, startSubIconsX - this.superScriptIcon.getIconWidth(), y);
        this.subScriptIcon.paintIcon(c, g, startSubIconsX - this.subScriptIcon.getIconWidth(), y + this.baseIcon.getIconHeight() - this.subScriptIcon.getIconHeight());
    }
}

